/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.player;

import dev.huskuraft.effortless.api.core.PlayerInfo;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.player.PlayerAvatarIcon;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;

public final class PlayerInfoList
extends EditableEntryList<PlayerInfo> {
    private final boolean isLargeIcon;

    public PlayerInfoList(Entrance entrance, int x, int y, int width, int height, boolean isLargeIcon) {
        super(entrance, x, y, width, height);
        this.isLargeIcon = isLargeIcon;
    }

    @Override
    protected EditableEntryList.Entry createHolder(PlayerInfo item) {
        if (this.isLargeIcon) {
            return new LargeEntry((Entrance)this.getEntrance(), item);
        }
        return new NormalEntry((Entrance)this.getEntrance(), item);
    }

    private static class LargeEntry
    extends EditableEntryList.Entry<PlayerInfo> {
        private PlayerAvatarIcon icon;
        private TextWidget textWidget;
        private TextWidget uuidTextWidget;

        public LargeEntry(Entrance entrance, PlayerInfo playerInfo) {
            super(entrance, playerInfo);
        }

        @Override
        public void onCreate() {
            this.icon = this.addWidget(new PlayerAvatarIcon(this.getEntrance(), this.getX() + 1, this.getY() + 1, 26, (PlayerInfo)this.getItem()));
            this.textWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 6 + 26, this.getY() + 4, Text.text(((PlayerInfo)this.getItem()).getName())));
            this.uuidTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 6 + 26, this.getY() + 4 + 11, Text.text(((PlayerInfo)this.getItem()).getId().toString()).withStyle(ChatFormatting.GRAY)));
        }

        @Override
        public void onReload() {
            this.icon.setPlayerInfo((PlayerInfo)this.item);
            this.textWidget.setMessage(((PlayerInfo)this.item).getName());
        }

        @Override
        public Text getNarration() {
            return Text.translate("narrator.select", ((PlayerInfo)this.getItem()).getDisplayName());
        }

        @Override
        public int getHeight() {
            return 32;
        }
    }

    private static class NormalEntry
    extends EditableEntryList.Entry<PlayerInfo> {
        private PlayerAvatarIcon icon;
        private TextWidget textWidget;

        public NormalEntry(Entrance entrance, PlayerInfo playerInfo) {
            super(entrance, playerInfo);
        }

        @Override
        public void onCreate() {
            this.icon = this.addWidget(new PlayerAvatarIcon(this.getEntrance(), this.getX() + 1, this.getY() + 1, 18, (PlayerInfo)this.getItem()));
            this.textWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + 6 + 18, this.getY() + 6, Text.text(((PlayerInfo)this.getItem()).getName())));
        }

        @Override
        public void onReload() {
            this.icon.setPlayerInfo((PlayerInfo)this.item);
            this.textWidget.setMessage(((PlayerInfo)this.item).getName());
        }

        @Override
        public Text getNarration() {
            return Text.translate("narrator.select", ((PlayerInfo)this.getItem()).getDisplayName());
        }

        @Override
        public int getHeight() {
            return 24;
        }
    }
}

