/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.settings;

import dev.huskuraft.effortless.api.gui.EntryList;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.AbstractEntryList;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.Text;
import java.util.function.Consumer;

public class SettingButtonsList
extends AbstractEntryList<Entry<?>> {
    public SettingButtonsList(Entrance entrance, int x, int y, int width, int height) {
        super(entrance, x, y, width, height);
    }

    @Override
    public boolean isRenderSelection() {
        return false;
    }

    public Button addTab(Text title, Consumer<Button> consumer) {
        return this.addEntry(new ButtonEntry(this.getEntrance(), this, title, 214, consumer)).getButton();
    }

    public Button addTab(String title, Consumer<Button> consumer) {
        return this.addEntry(new ButtonEntry(this.getEntrance(), this, Text.text(title), 214, consumer)).getButton();
    }

    private static final class ButtonEntry
    extends Entry<Void> {
        private Consumer<Button> consumer;
        private int width;
        private Button button;

        public ButtonEntry(Entrance entrance, EntryList entryList, Text title, int width, Consumer<Button> consumer) {
            super(entrance, entryList, null);
            this.setMessage(title);
            this.consumer = consumer;
            this.width = width;
        }

        @Override
        public void onCreate() {
            super.onCreate();
            this.button = this.addWidget(new Button((Entrance)this.getEntrance(), this.getX(), this.getY(), this.getWidth(), 20, this.getMessage()));
            this.button.setOnPressListener(button -> this.consumer.accept(button));
        }

        public Button getButton() {
            return this.button;
        }

        @Override
        public int getHeight() {
            return 24;
        }
    }

    public static abstract class Entry<T>
    extends EditableEntryList.Entry<T> {
        protected Entry(Entrance entrance, T item) {
            super(entrance, item);
        }

        protected Entry(Entrance entrance, EntryList entryList, T item) {
            super(entrance, entryList, item);
        }

        @Override
        public int getWidth() {
            return MathUtils.min(282, this.getParent().getWidth() - 12);
        }
    }
}

