/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.structure;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.gui.AbstractWidget;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.input.KeyBinding;
import dev.huskuraft.effortless.api.input.OptionKeys;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.Option;
import dev.huskuraft.effortless.building.clipboard.Clipboard;
import dev.huskuraft.effortless.building.config.BuilderConfig;
import dev.huskuraft.effortless.building.config.ClientConfig;
import dev.huskuraft.effortless.building.config.PassiveMode;
import dev.huskuraft.effortless.building.history.UndoRedo;
import dev.huskuraft.effortless.building.pattern.Pattern;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.replace.Replace;
import dev.huskuraft.effortless.building.replace.ReplaceStrategy;
import dev.huskuraft.effortless.building.settings.Misc;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.screen.clipboard.EffortlessClipboardScreen;
import dev.huskuraft.effortless.screen.pattern.EffortlessPatternScreen;
import dev.huskuraft.effortless.screen.settings.EffortlessSettingsScreen;
import dev.huskuraft.effortless.screen.wheel.AbstractWheelScreen;
import java.util.ArrayList;
import java.util.Arrays;

public class EffortlessStructureScreen
extends AbstractWheelScreen<Structure, Option> {
    private static final AbstractWheelScreen.Button<Option> UNDO_OPTION = EffortlessStructureScreen.button(UndoRedo.UNDO);
    private static final AbstractWheelScreen.Button<Option> REDO_OPTION = EffortlessStructureScreen.button(UndoRedo.REDO);
    private static final AbstractWheelScreen.Button<Option> SETTING_OPTION = EffortlessStructureScreen.button(Misc.SETTINGS);
    private static final AbstractWheelScreen.Button<Option> PATTERN_OPTION = EffortlessStructureScreen.lazyButton(() -> {
        EffortlessClient entrance = EffortlessClient.getInstance();
        Context context = entrance.getStructureBuilder().getContext(entrance.getClient().getPlayer());
        ArrayList<Text> descriptions = new ArrayList<Text>();
        Text name = context.pattern().getNameText();
        if (context.pattern().enabled()) {
            if (!context.pattern().transformers().isEmpty()) {
                descriptions.add(Text.empty());
            }
            for (Transformer transformer : context.pattern().transformers()) {
                descriptions.add(Text.text("").append(transformer.getName().withStyle(ChatFormatting.GRAY)).append("").withStyle(ChatFormatting.GRAY));
                for (Text description : transformer.getDescriptions()) {
                    descriptions.add(Text.text(" ").append(description.withStyle(ChatFormatting.DARK_GRAY)));
                }
            }
        }
        descriptions.add(Text.empty());
        descriptions.add(Text.translate("effortless.tooltip.click_to_toggle_on_off", OptionKeys.KEY_ATTACK.getKeyBinding().getKey().getNameText()).withStyle(ChatFormatting.DARK_GRAY));
        descriptions.add(Text.translate("effortless.tooltip.click_to_edit_pattern", OptionKeys.KEY_USE.getKeyBinding().getKey().getNameText()).withStyle(ChatFormatting.DARK_GRAY));
        return EffortlessStructureScreen.button(context.pattern(), context.pattern().enabled(), name, descriptions);
    });
    private static final AbstractWheelScreen.Button<Option> REPLACE_OPTION = EffortlessStructureScreen.lazyButton(() -> {
        EffortlessClient entrance = EffortlessClient.getInstance();
        Context context = entrance.getStructureBuilder().getContext(entrance.getClient().getPlayer());
        Text name = context.replace().getNameText();
        ArrayList<Text> descriptions = new ArrayList<Text>();
        descriptions.add(Text.empty());
        descriptions.add(Text.translate("effortless.tooltip.click_to_switch_replace_strategy", OptionKeys.KEY_ATTACK.getKeyBinding().getKey().getNameText()).withStyle(ChatFormatting.DARK_GRAY));
        descriptions.add(Text.translate("effortless.tooltip.click_to_toggle_quick_replace", OptionKeys.KEY_USE.getKeyBinding().getKey().getNameText()).withStyle(ChatFormatting.DARK_GRAY));
        return EffortlessStructureScreen.button(context.replace(), context.replace().replaceStrategy() != ReplaceStrategy.DISABLED || context.replace().isQuick(), name, descriptions);
    });
    private static final AbstractWheelScreen.Button<Option> PASSIVE_MODE_OPTION = EffortlessStructureScreen.lazyButton(() -> {
        EffortlessClient entrance = EffortlessClient.getInstance();
        BuilderConfig builderConfig = ((ClientConfig)entrance.getConfigStorage().get()).builderConfig();
        return EffortlessStructureScreen.button(builderConfig.passiveMode() ? PassiveMode.ENABLED : PassiveMode.DISABLED, builderConfig.passiveMode());
    });
    private static final AbstractWheelScreen.Button<Option> CLIPBOARD_OPTION = EffortlessStructureScreen.lazyButton(() -> {
        EffortlessClient entrance = EffortlessClient.getInstance();
        Context context = entrance.getStructureBuilder().getContext(entrance.getClient().getPlayer());
        ArrayList<Text> descriptions = new ArrayList<Text>();
        descriptions.add(Text.empty());
        descriptions.add(Text.translate("effortless.tooltip.click_to_toggle_on_off", OptionKeys.KEY_ATTACK.getKeyBinding().getKey().getNameText()).withStyle(ChatFormatting.DARK_GRAY));
        descriptions.add(Text.translate("effortless.tooltip.click_to_edit_clipboard", OptionKeys.KEY_USE.getKeyBinding().getKey().getNameText()).withStyle(ChatFormatting.DARK_GRAY));
        return EffortlessStructureScreen.button(context.clipboard(), context.clipboard().enabled(), context.clipboard().getNameText(), descriptions);
    });
    private static final AbstractWheelScreen.Button<Option> GO_BACK_OPTION = EffortlessStructureScreen.button(Misc.GO_BACK, false);
    private final KeyBinding assignedKey;
    private AbstractWidget passiveModeTextWidget;

    public EffortlessStructureScreen(Entrance entrance, KeyBinding assignedKey) {
        super(entrance, Text.translate("effortless.building.radial.title"));
        this.assignedKey = assignedKey;
    }

    public static AbstractWheelScreen.Slot<Structure> slot(Structure structure) {
        return EffortlessStructureScreen.slot((Object)structure.getMode(), structure.getMode().getDisplayName(), structure.getMode().getIcon(), structure.getMode().getTintColor(), structure);
    }

    @Override
    protected EffortlessClient getEntrance() {
        return super.getEntrance();
    }

    protected Player getPlayer() {
        return this.getEntrance().getClient().getPlayer();
    }

    @Override
    public KeyBinding getAssignedKeyBinds() {
        return this.assignedKey;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.setRadialSelectResponder((slot, click) -> {
            this.setScaleAnimation(3.0f);
            this.getEntrance().getStructureBuilder().setStructure(this.getPlayer(), (Structure)slot.getContent());
        });
        this.setRadialOptionSelectResponder((entry, click) -> {
            this.setScaleAnimation(3.0f);
            Object patt0$temp = entry.getContent();
            if (patt0$temp instanceof Misc) {
                Misc misc = (Misc)patt0$temp;
                switch (misc) {
                    case SETTINGS: {
                        this.detach();
                        new EffortlessSettingsScreen(this.getEntrance()).attach();
                        break;
                    }
                    case PATTERN: {
                        this.detach();
                        new EffortlessPatternScreen(this.getEntrance()).attach();
                        break;
                    }
                    case GO_BACK: {
                        this.setLeftButtons();
                    }
                }
                return;
            }
            Object patt1$temp = entry.getContent();
            if (patt1$temp instanceof Pattern) {
                Pattern pattern = (Pattern)patt1$temp;
                if (click.booleanValue()) {
                    this.getEntrance().getStructureBuilder().setPattern(this.getPlayer(), pattern.toggled());
                    return;
                }
                if (this.getEntrance().getStructureBuilder().checkPermission(this.getPlayer())) {
                    this.detach();
                    new EffortlessPatternScreen(this.getEntrance()).attach();
                }
                return;
            }
            Object patt2$temp = entry.getContent();
            if (patt2$temp instanceof Clipboard) {
                Clipboard clipboard = (Clipboard)patt2$temp;
                if (click.booleanValue()) {
                    this.getEntrance().getStructureBuilder().setClipboard(this.getPlayer(), clipboard.toggled());
                    return;
                }
                if (this.getEntrance().getStructureBuilder().checkPermission(this.getPlayer())) {
                    this.detach();
                    new EffortlessClipboardScreen(this.getEntrance()).attach();
                }
                return;
            }
            Object patt3$temp = entry.getContent();
            if (patt3$temp instanceof UndoRedo) {
                UndoRedo undoRedo = (UndoRedo)patt3$temp;
                switch (undoRedo) {
                    case UNDO: {
                        this.getEntrance().getStructureBuilder().undo(this.getPlayer());
                        break;
                    }
                    case REDO: {
                        this.getEntrance().getStructureBuilder().redo(this.getPlayer());
                    }
                }
                return;
            }
            Object patt4$temp = entry.getContent();
            if (patt4$temp instanceof Replace) {
                Replace replace = (Replace)patt4$temp;
                if (click.booleanValue()) {
                    this.getEntrance().getStructureBuilder().setReplace(this.getPlayer(), this.getEntrance().getStructureBuilder().getContext(this.getPlayer()).replace().withReplaceStrategy(this.getEntrance().getStructureBuilder().getContext(this.getPlayer()).replace().replaceStrategy().next()));
                    return;
                }
                this.getEntrance().getStructureBuilder().setReplace(this.getPlayer(), this.getEntrance().getStructureBuilder().getContext(this.getPlayer()).replace().withQuick(!this.getEntrance().getStructureBuilder().getContext(this.getPlayer()).replace().isQuick()));
                return;
            }
            Object patt5$temp = entry.getContent();
            if (patt5$temp instanceof PassiveMode) {
                PassiveMode passiveMode = (PassiveMode)patt5$temp;
                this.getEntrance().getConfigStorage().update(config -> config.withPassiveMode(passiveMode != PassiveMode.ENABLED));
                return;
            }
            Object patt6$temp = entry.getContent();
            if (patt6$temp instanceof BuildFeature) {
                BuildFeature buildFeature = (BuildFeature)patt6$temp;
                Structure structure = this.getEntrance().getStructureBuilder().getContext(this.getPlayer()).structure().withFeature(buildFeature);
                if (this.getEntrance().getStructureBuilder().setStructure(this.getPlayer(), structure)) {
                    this.getEntrance().getConfigStorage().setStructure(structure);
                }
                return;
            }
        });
        this.passiveModeTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getX() + this.getWidth() - 10, this.getY() + this.getHeight() - 18, Text.translate("effortless.option.passive_mode"), TextWidget.Gravity.END));
        this.setLeftButtons();
    }

    private void setLeftButtons() {
        this.setLeftButtons(EffortlessStructureScreen.buttonSet(REPLACE_OPTION, REDO_OPTION, UNDO_OPTION), EffortlessStructureScreen.buttonSet(CLIPBOARD_OPTION, PATTERN_OPTION, SETTING_OPTION));
    }

    @Override
    public void onReload() {
        this.passiveModeTextWidget.setVisible(((ClientConfig)this.getEntrance().getConfigStorage().get()).builderConfig().passiveMode());
        this.setRadialSlots(((ClientConfig)this.getEntrance().getConfigStorage().get()).structureMap().values().stream().map(EffortlessStructureScreen::slot).toList());
        Structure structure = this.getEntrance().getStructureBuilder().getContext(this.getPlayer()).structure();
        this.setSelectedSlots(EffortlessStructureScreen.slot(structure));
        this.setRightButtons(structure.getSupportedFeatures().stream().map(feature -> EffortlessStructureScreen.buttonSet(Arrays.stream(feature.getEntries()).map(option -> EffortlessStructureScreen.button(option, structure.getFeatures().contains(option))).toList())).toList());
    }
}

