/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.transformer;

import dev.huskuraft.effortless.api.core.BlockItem;
import dev.huskuraft.effortless.api.core.Items;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.gui.tooltip.Palette;
import dev.huskuraft.effortless.api.gui.tooltip.TooltipHelper;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.pattern.randomize.Chance;
import dev.huskuraft.effortless.building.pattern.randomize.ItemRandomizer;
import dev.huskuraft.effortless.building.pattern.randomize.Randomizer;
import dev.huskuraft.effortless.screen.item.EffortlessItemPickerScreen;
import dev.huskuraft.effortless.screen.transformer.ItemChanceList;
import dev.huskuraft.effortless.screen.transformer.TransformerList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class EffortlessItemRandomizerEditScreen
extends AbstractPanelScreen {
    private final Consumer<ItemRandomizer> consumer;
    private final ItemRandomizer defaultRandomizer;
    private ItemRandomizer randomizer;
    private TextWidget titleTextWidget;
    private TransformerList transformerEntries;
    private ItemChanceList entries;
    private Button sourceButton;
    private Button orderButton;
    private Button targetButton;
    private Button upButton;
    private Button downButton;
    private Button deleteButton;
    private Button addButton;
    private Button saveButton;
    private Button cancelButton;

    public EffortlessItemRandomizerEditScreen(Entrance entrance, Consumer<ItemRandomizer> consumer, ItemRandomizer randomizer) {
        super(entrance, Text.translate("effortless.transformer.randomizer.edit.title"));
        this.consumer = consumer;
        this.defaultRandomizer = randomizer;
        this.randomizer = randomizer;
    }

    @Override
    public void onCreate() {
        this.setWidth(264);
        this.setHeight(this.randomizer.getSource() == ItemRandomizer.Source.CUSTOMIZE ? 238 : 134);
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.transformerEntries = this.addWidget(new TransformerList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12, 38));
        this.transformerEntries.setShowScrollBar(false);
        this.transformerEntries.setRenderSelection(false);
        this.transformerEntries.reset(List.of(this.randomizer));
        this.sourceButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.source", this.randomizer.getSource().getDisplayName()), button -> {
            ItemRandomizer.Source newSource = ItemRandomizer.Source.values()[(this.randomizer.source().ordinal() + 1) % ItemRandomizer.Source.values().length];
            this.randomizer = this.randomizer.withSource(newSource);
            this.sourceButton.setMessage(Text.translate("effortless.transformer.randomizer.edit.source", this.randomizer.getSource().getDisplayName()));
            this.recreate();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), 18 + this.transformerEntries.getHeight() + 54, 1.0f, 0.0f, 1.0f).build());
        this.orderButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.order", this.randomizer.getOrder().getDisplayName()), button -> {
            Randomizer.Order newOrder = Randomizer.Order.values()[(this.randomizer.getOrder().ordinal() + 1) % Randomizer.Order.values().length];
            this.randomizer = this.randomizer.withOrder(newOrder);
            this.orderButton.setMessage(Text.translate("effortless.transformer.randomizer.edit.order", this.randomizer.order().getDisplayName()));
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), 18 + this.transformerEntries.getHeight() + 54, 0.0f, 0.0f, 0.5f).build());
        this.targetButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.target", this.randomizer.getTarget().getDisplayName()), button -> {
            Randomizer.Target newTarget = Randomizer.Target.values()[(this.randomizer.getTarget().ordinal() + 1) % Randomizer.Target.values().length];
            this.randomizer = this.randomizer.withTarget(newTarget);
            this.targetButton.setMessage(Text.translate("effortless.transformer.randomizer.edit.target", this.randomizer.target().getDisplayName()));
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), 18 + this.transformerEntries.getHeight() + 54, 0.0f, 0.5f, 0.5f).build());
        this.entries = this.addWidget(new ItemChanceList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 52 + this.transformerEntries.getHeight() + 18, this.getWidth() - 12 - 8, this.getHeight() - 18 - 52 - this.transformerEntries.getHeight() - 54));
        this.entries.setAlwaysShowScrollbar(true);
        this.entries.reset(this.randomizer.getChances());
        this.upButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.up"), button -> {
            if (this.entries.hasSelected()) {
                this.entries.moveUpSelected();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.25f).build());
        this.downButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.down"), button -> {
            if (this.entries.hasSelected()) {
                this.entries.moveDownSelected();
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.25f, 0.25f).build());
        this.deleteButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.delete"), button -> this.entries.deleteSelected()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.5f, 0.25f).build());
        this.addButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.add"), button -> new EffortlessItemPickerScreen(this.getEntrance(), item -> item instanceof BlockItem || item.equals(Items.AIR.item()), item -> {
            this.entries.insertSelected(Chance.of(item, 1));
            this.onReload();
        }).attach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 1.0f, 0.75f, 0.25f).build());
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.saveButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.randomizer.edit.save"), button -> {
            this.consumer.accept(this.randomizer);
            this.detach();
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
    }

    @Override
    public void onReload() {
        this.upButton.setActive(this.entries.hasSelected() && this.entries.indexOfSelected() > 0);
        this.downButton.setActive(this.entries.hasSelected() && this.entries.indexOfSelected() < this.entries.children().size() - 1);
        this.deleteButton.setActive(this.entries.hasSelected());
        this.addButton.setActive(this.entries.children().size() <= 36);
        this.entries.setVisible(this.randomizer.source() == ItemRandomizer.Source.CUSTOMIZE);
        this.upButton.setVisible(this.randomizer.source() == ItemRandomizer.Source.CUSTOMIZE);
        this.downButton.setVisible(this.randomizer.source() == ItemRandomizer.Source.CUSTOMIZE);
        this.deleteButton.setVisible(this.randomizer.source() == ItemRandomizer.Source.CUSTOMIZE);
        this.addButton.setVisible(this.randomizer.source() == ItemRandomizer.Source.CUSTOMIZE);
        ArrayList<Text> sourceTooltip = new ArrayList<Text>();
        sourceTooltip.add(Text.translate("effortless.transformer.randomizer.edit.source.tooltip.title"));
        sourceTooltip.add(this.randomizer.getSource().getDisplayName().withStyle(ChatFormatting.GOLD));
        sourceTooltip.add(Text.empty());
        sourceTooltip.add(TooltipHelper.holdShiftForSummary());
        if (TooltipHelper.isSummaryButtonDown()) {
            sourceTooltip.add(Text.empty());
            sourceTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.transformer.randomizer.edit.source.tooltip.message").withStyle(ChatFormatting.GRAY)));
            for (ItemRandomizer.Source source : ItemRandomizer.Source.values()) {
                sourceTooltip.add(Text.empty());
                sourceTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.text("").append(source.getDisplayName()).append("\n").withColor(Palette.GRAY_AND_WHITE.highlight().color()).append(Text.translate("effortless.transformer.randomizer.edit.source.tooltip.%s".formatted(source.getName())).withColor(Palette.GRAY_AND_WHITE.primary().color()))));
            }
        }
        this.sourceButton.setTooltip(sourceTooltip);
        ArrayList<Text> orderTooltip = new ArrayList<Text>();
        orderTooltip.add(Text.translate("effortless.transformer.randomizer.edit.order.tooltip.title"));
        orderTooltip.add(this.randomizer.getOrder().getDisplayName().withStyle(ChatFormatting.GOLD));
        orderTooltip.add(Text.empty());
        orderTooltip.add(TooltipHelper.holdShiftForSummary());
        if (TooltipHelper.isSummaryButtonDown()) {
            orderTooltip.add(Text.empty());
            orderTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.transformer.randomizer.edit.order.tooltip.message").withStyle(ChatFormatting.GRAY)));
            for (Randomizer.Order order : Randomizer.Order.values()) {
                orderTooltip.add(Text.empty());
                orderTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.text("").append(order.getDisplayName()).append("\n").withColor(Palette.GRAY_AND_WHITE.highlight().color()).append(Text.translate("effortless.transformer.randomizer.edit.order.tooltip.%s".formatted(order.getName())).withColor(Palette.GRAY_AND_WHITE.primary().color()))));
            }
        }
        this.orderButton.setTooltip(orderTooltip);
        ArrayList<Text> targetTooltip = new ArrayList<Text>();
        targetTooltip.add(Text.translate("effortless.transformer.randomizer.edit.target.tooltip.title"));
        targetTooltip.add(this.randomizer.getTarget().getDisplayName().withStyle(ChatFormatting.GOLD));
        targetTooltip.add(Text.empty());
        targetTooltip.add(TooltipHelper.holdShiftForSummary());
        if (TooltipHelper.isSummaryButtonDown()) {
            targetTooltip.add(Text.empty());
            targetTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.translate("effortless.transformer.randomizer.edit.target.tooltip.message").withStyle(ChatFormatting.GRAY)));
            for (Randomizer.Target target : Randomizer.Target.values()) {
                targetTooltip.add(Text.empty());
                targetTooltip.addAll(TooltipHelper.wrapLines(this.getTypeface(), Text.text("").append(target.getDisplayName()).append("\n").withColor(Palette.GRAY_AND_WHITE.highlight().color()).append(Text.translate("effortless.transformer.randomizer.edit.target.tooltip.%s".formatted(target.getName())).withColor(Palette.GRAY_AND_WHITE.primary().color()))));
            }
        }
        this.targetButton.setTooltip(targetTooltip);
        this.randomizer = this.randomizer.withChances(this.entries.items());
        this.transformerEntries.reset(List.of(this.randomizer));
    }
}

