/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.transformer;

import dev.huskuraft.effortless.EffortlessClient;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.config.ClientConfig;
import dev.huskuraft.effortless.building.config.PatternConfig;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import dev.huskuraft.effortless.screen.transformer.TransformerList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class EffortlessTransformerPresetsSelectScreen
extends AbstractPanelScreen {
    private final Consumer<Transformer> consumer;
    private final List<Button> tabButtons = new ArrayList<Button>();
    private Map<Transformers, List<? extends Transformer>> builtInTransformers;
    private Map<Transformers, List<? extends Transformer>> transformers;
    private TransformerList entries;
    private TextWidget titleTextWidget;
    private Button useTemplateButton;
    private Button cancelButton;
    private Transformers selectedType = Transformers.ARRAY;

    public EffortlessTransformerPresetsSelectScreen(Entrance entrance, Consumer<Transformer> consumer) {
        super(entrance, Text.translate("effortless.transformer.template_select.title").withStyle(ChatFormatting.DARK_GRAY), 264, 238);
        this.consumer = consumer;
        this.builtInTransformers = PatternConfig.getBuiltInPresets().getByType();
        this.transformers = ((ClientConfig)this.getEntrance().getConfigStorage().get()).patternConfig().getByType();
    }

    @Override
    protected EffortlessClient getEntrance() {
        return (EffortlessClient)super.getEntrance();
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.useTemplateButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.transformer.template_select.use_template"), button -> {
            if (this.entries.hasSelected()) {
                this.detach();
                this.consumer.accept((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
            }
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
        this.tabButtons.clear();
        for (Transformers type : Transformers.values()) {
            this.tabButtons.add(this.addWidget(Button.builder((Entrance)this.getEntrance(), type.getTitleText(), button -> this.setSelectedType(type)).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), 48, 0.0f, 1.0f * (float)type.ordinal() / (float)Transformers.values().length, 1.0f / (float)Transformers.values().length).build()));
        }
        this.entries = this.addWidget(new TransformerList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18 + 28, this.getWidth() - 12 - 8, this.getHeight() - 18 - 28 - 30));
        this.entries.setAlwaysShowScrollbar(true);
        this.setSelectedType(this.selectedType);
    }

    @Override
    public void onReload() {
        this.useTemplateButton.setActive(this.entries.hasSelected());
        for (Button tabButton : this.tabButtons) {
            tabButton.setActive(!tabButton.getMessage().equals(this.selectedType.getTitleText()));
        }
        this.entries.reset(Stream.concat(this.builtInTransformers.get((Object)this.selectedType).stream(), this.transformers.get((Object)this.selectedType).stream()).toList());
        if (this.entries.consumeDoubleClick() && this.entries.hasSelected()) {
            this.detach();
            this.consumer.accept((Transformer)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
        }
    }

    private void setSelectedType(Transformers type) {
        this.selectedType = type;
        this.entries.setSelected(null);
        this.entries.setScrollAmount(0.0);
    }
}

