/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network;

import immersive_melodies.network.Network;
import immersive_melodies.network.c2s.UploadMelodyRequest;
import immersive_melodies.network.s2c.MelodyResponse;
import immersive_melodies.resources.Melody;
import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class PacketSplitter {
    private static final int FRAGMENT_SIZE = 8192;

    private static List<byte[]> fragmentate(Melody melody) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        melody.encode(buffer);
        byte[] array = new byte[buffer.writerIndex()];
        buffer.getBytes(0, array);
        LinkedList<byte[]> fragments = new LinkedList<byte[]>();
        for (int i = 0; i < array.length; i += 8192) {
            byte[] fragment = new byte[Math.min(8192, array.length - i)];
            System.arraycopy(array, i, fragment, 0, fragment.length);
            fragments.add(fragment);
        }
        return fragments;
    }

    public static void sendToServer(String name, Melody melody) {
        List<byte[]> fragments = PacketSplitter.fragmentate(melody);
        int length = fragments.stream().mapToInt(f -> ((byte[])f).length).sum();
        for (byte[] fragment : fragments) {
            Network.sendToServer(new UploadMelodyRequest(name, fragment, length));
        }
    }

    public static void sendToPlayer(ResourceLocation identifier, Melody melody, ServerPlayer player) {
        List<byte[]> fragments = PacketSplitter.fragmentate(melody);
        int length = fragments.stream().mapToInt(f -> ((byte[])f).length).sum();
        for (byte[] fragment : fragments) {
            Network.sendToPlayer(new MelodyResponse(identifier.toString(), fragment, length), player);
        }
    }
}

