/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.block.be.CrafterBlockEntity;
import org.violetmoon.quark.content.automation.module.CrafterModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class CrafterBlock
extends ZetaBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<PowerState> POWER = EnumProperty.m_61587_((String)"power", PowerState.class);

    public CrafterBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(POWER, (Comparable)((Object)PowerState.OFF)));
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.f_257028_);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CrafterBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof CrafterBlockEntity) {
            CrafterBlockEntity cbe = (CrafterBlockEntity)be;
            player.m_5893_((MenuProvider)cbe);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CrafterBlockEntity) {
                CrafterBlockEntity cbe = (CrafterBlockEntity)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)cbe);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        boolean bl = world.m_276867_(pos) || world.m_276867_(pos.m_7494_());
        world.m_7731_(pos, (BlockState)state.m_61124_(POWER, (Comparable)((Object)(bl ? PowerState.ON : PowerState.OFF))), 2);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        PowerState powerState = (PowerState)((Object)state.m_61143_(POWER));
        boolean bl = world.m_276867_(pos) || world.m_276867_(pos.m_7494_());
        boolean bl2 = powerState.powered();
        if (bl && !bl2) {
            world.m_186460_(pos, (Block)this, 6);
            ((CrafterBlockEntity)world.m_7702_(pos)).craft();
            world.m_7731_(pos, (BlockState)state.m_61124_(POWER, (Comparable)((Object)PowerState.TRIGGERED)), 2);
        } else if (!bl && state.m_61143_(POWER) != PowerState.OFF) {
            world.m_7731_(pos, (BlockState)state.m_61124_(POWER, (Comparable)((Object)PowerState.OFF)), 2);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return ((CrafterBlockEntity)world.m_7702_(pos)).getComparatorOutput();
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return CrafterBlock.createTickerHelper(type, CrafterModule.blockEntityType, CrafterBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWER});
    }

    public static enum PowerState implements StringRepresentable
    {
        OFF("off"),
        TRIGGERED("triggered"),
        ON("on");

        private final String name;

        private PowerState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean powered() {
            return this != OFF;
        }
    }
}

