/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.api.ITrowelable;
import org.violetmoon.quark.api.IUsageTickerOverride;
import org.violetmoon.quark.content.tools.module.TrowelModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.ItemNBTHelper;
import org.violetmoon.zeta.util.MiscUtil;

public class TrowelItem
extends ZetaItem
implements IUsageTickerOverride {
    private static final String TAG_PLACING_SEED = "placing_seed";
    private static final String TAG_LAST_STACK = "last_stack";

    public TrowelItem(ZetaModule module) {
        super("trowel", module, new Item.Properties().m_41503_(255));
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_256869_, (ItemLike)this, (ItemLike)Items.f_42574_, (boolean)false);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.m_43724_();
        ArrayList<Integer> targets = new ArrayList<Integer>();
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!TrowelItem.isValidTarget(stack, context)) continue;
            targets.add(i);
        }
        if (targets.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack trowel = player.m_21120_(hand);
        long seed = ItemNBTHelper.getLong((ItemStack)trowel, (String)TAG_PLACING_SEED, (long)0L);
        Random rand = new Random(seed);
        ItemNBTHelper.setLong((ItemStack)trowel, (String)TAG_PLACING_SEED, (long)rand.nextLong());
        int targetSlot = (Integer)targets.get(rand.nextInt(targets.size()));
        ItemStack toPlaceStack = inventory.m_8020_(targetSlot);
        player.m_21008_(hand, toPlaceStack);
        InteractionResult result = toPlaceStack.m_41661_((UseOnContext)new TrowelBlockItemUseContext(context, toPlaceStack));
        ItemStack newHandItem = player.m_21120_(hand);
        player.m_21008_(hand, trowel);
        inventory.m_6836_(targetSlot, newHandItem);
        if (result.m_19077_()) {
            CompoundTag cmp = toPlaceStack.serializeNBT();
            ItemNBTHelper.setCompound((ItemStack)trowel, (String)TAG_LAST_STACK, (CompoundTag)cmp);
            if (TrowelModule.maxDamage > 0) {
                MiscUtil.damageStack((Player)player, (InteractionHand)hand, (ItemStack)context.m_43722_(), (int)1);
            }
        }
        return result;
    }

    private static boolean isValidTarget(ItemStack stack, UseOnContext context) {
        Item item = stack.m_41720_();
        if (stack.m_204117_(TrowelModule.whitelist)) {
            return true;
        }
        if (stack.m_204117_(TrowelModule.blacklist)) {
            return false;
        }
        if (item instanceof ITrowelable) {
            ITrowelable t = (ITrowelable)item;
            return t.canBeTroweled(stack, context);
        }
        return !stack.m_41619_() && item instanceof BlockItem;
    }

    public static ItemStack getLastStack(ItemStack stack) {
        CompoundTag cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_LAST_STACK, (boolean)false);
        return ItemStack.m_41712_((CompoundTag)cmp);
    }

    public int getMaxDamageZeta(ItemStack stack) {
        return TrowelModule.maxDamage;
    }

    public boolean m_41465_() {
        return TrowelModule.maxDamage > 0;
    }

    @Override
    public ItemStack getUsageTickerItem(ItemStack stack) {
        return TrowelItem.getLastStack(stack);
    }

    class TrowelBlockItemUseContext
    extends BlockPlaceContext {
        public TrowelBlockItemUseContext(UseOnContext context, ItemStack stack) {
            super(context.m_43725_(), context.m_43723_(), context.m_43724_(), stack, new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_()));
        }
    }
}

