/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.GlobeBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PedestalBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PedestalBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class PedestalBlockTileRenderer
implements BlockEntityRenderer<PedestalBlockTile> {
    private final ItemRenderer itemRenderer;
    private final EntityRenderDispatcher entityRenderer;

    public PedestalBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
        this.entityRenderer = minecraft.m_91290_();
    }

    protected boolean canRenderName(ItemStack item, PedestalBlockTile tile, PedestalBlockTile.DisplayType type) {
        if (Minecraft.m_91404_() && item.m_41788_() && !type.isGlobe()) {
            double d0 = this.entityRenderer.m_114378_((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5);
            return d0 < 256.0;
        }
        return false;
    }

    public static void renderName(Component name, float h, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft mc = Minecraft.m_91087_();
        int s = "Dinnerbone".equals(name.getString()) ? -1 : 1;
        poseStack.m_85841_((float)s, (float)s, 1.0f);
        boolean i = false;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, h, 0.0f);
        poseStack.m_252781_(mc.m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float f1 = mc.f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        float f2 = (float)(-mc.f_91062_.m_92852_((FormattedText)name)) / 2.0f;
        mc.f_91062_.m_272077_(name, f2, (float)i, -1, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, j, combinedLightIn);
        poseStack.m_85849_();
    }

    public void render(PedestalBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.m_7983_()) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 1.125, 0.5);
            PedestalBlockTile.DisplayType displayType = tile.getDisplayType();
            ItemStack stack = tile.getDisplayedItem();
            if (this.canRenderName(stack, tile, displayType)) {
                PedestalBlockTileRenderer.renderName(tile.m_8020_(0).m_41786_(), 0.875f, matrixStackIn, bufferIn, combinedLightIn);
            }
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStackIn.m_85837_(0.0, 0.25, 0.0);
            if (tile.m_58900_().m_61143_(PedestalBlock.AXIS) == Direction.Axis.X) {
                matrixStackIn.m_252781_(RotHlpr.Y90);
            }
            ItemDisplayContext transform = ItemDisplayContext.FIXED;
            if (ClientConfigs.Blocks.PEDESTAL_SPECIAL.get().booleanValue()) {
                switch (displayType) {
                    case SWORD: {
                        matrixStackIn.m_85837_(0.0, -0.03125, 0.0);
                        matrixStackIn.m_85841_(1.5f, 1.5f, 1.5f);
                        matrixStackIn.m_252781_(RotHlpr.Z135);
                        break;
                    }
                    case TRIDENT: {
                        matrixStackIn.m_85837_(0.0, 0.03125, 0.0);
                        matrixStackIn.m_85841_(1.5f, 1.5f, 1.5f);
                        matrixStackIn.m_252781_(RotHlpr.ZN45);
                        break;
                    }
                    case CRYSTAL: {
                        this.entityRenderer.m_114384_((Entity)CapturedMobCache.getEndCrystal(tile.m_58904_()), 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                        matrixStackIn.m_85849_();
                        return;
                    }
                    default: {
                        if (ClientConfigs.Blocks.PEDESTAL_SPIN.get().booleanValue()) {
                            matrixStackIn.m_252880_(0.0f, 0.375f, 0.0f);
                            matrixStackIn.m_85841_(1.5f, 1.5f, 1.5f);
                            int scale = (int)(ClientConfigs.Blocks.PEDESTAL_SPEED.get() * 360.0);
                            long time = tile.m_58904_().m_46467_();
                            float angle = ((float)Math.floorMod(time, (long)scale) + partialTicks) / (float)scale;
                            Quaternionf rotation = Axis.f_252436_.m_252961_((float)((double)angle * Math.PI * 10.0));
                            matrixStackIn.m_252781_(rotation);
                        }
                        if (!displayType.isGlobe()) break;
                        if (GlobeBlockTileRenderer.INSTANCE != null) {
                            boolean sepia = tile.getDisplayType() == PedestalBlockTile.DisplayType.SEPIA_GLOBE;
                            Pair<GlobeManager.Model, ResourceLocation> pair = stack.m_41788_() ? GlobeManager.Type.getModelAndTexture(stack.m_41786_().getString()) : Pair.of((Object)((Object)GlobeManager.Model.GLOBE), null);
                            GlobeBlockTileRenderer.INSTANCE.renderGlobe(pair, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, sepia, tile.m_58904_());
                        }
                        matrixStackIn.m_85849_();
                        return;
                    }
                }
            }
            if (MiscUtils.FESTIVITY.isAprilsFool()) {
                stack = new ItemStack((ItemLike)Items.f_42329_);
            }
            this.itemRenderer.m_269128_(stack, transform, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, tile.m_58904_(), 0);
            matrixStackIn.m_85849_();
        }
    }
}

