/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;

public record ResourceOrTagKeyArgument<T>(@Nullable ResourceKey<? extends Registry<T>> registry) implements ArgumentType<Result>
{
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");

    public static ResourceOrTagKeyArgument<?> key() {
        return new ResourceOrTagKeyArgument(null);
    }

    public static <T> ResourceOrTagKeyArgument<T> registry(ResourceKey<? extends Registry<T>> registry) {
        return new ResourceOrTagKeyArgument<T>(registry);
    }

    public static Result get(CommandContext<CommandSourceStack> context, String key) {
        return (Result)context.getArgument(key, Result.class);
    }

    public Result parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '#') {
            int pos = reader.getCursor();
            try {
                reader.skip();
                return new Result(ResourceLocation.m_135818_((StringReader)reader), true);
            }
            catch (CommandSyntaxException ex) {
                reader.setCursor(pos);
                throw ex;
            }
        }
        return new Result(ResourceLocation.m_135818_((StringReader)reader), false);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object;
        if (this.registry != null && (object = context.getSource()) instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider suggestions = (SharedSuggestionProvider)object;
            return suggestions.m_212095_(this.registry, SharedSuggestionProvider.ElementSuggestionType.ALL, builder, context);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record Result(ResourceLocation location, boolean isTag) {
        public <T> TagKey<T> resource(ResourceKey<? extends Registry<T>> registry) {
            if (this.isTag) {
                throw new IllegalStateException("Cannot create a resource key for a tag result");
            }
            return TagKey.m_203882_(registry, (ResourceLocation)this.location);
        }

        public <T> TagKey<T> tag(ResourceKey<? extends Registry<T>> registry) {
            if (this.isTag) {
                return TagKey.m_203882_(registry, (ResourceLocation)this.location);
            }
            throw new IllegalStateException("Cannot create a tag for a value result");
        }

        public TagEntry tagEntry() {
            if (this.isTag) {
                return TagEntry.m_215949_((ResourceLocation)this.location);
            }
            return TagEntry.m_215925_((ResourceLocation)this.location);
        }

        @Override
        public String toString() {
            if (this.isTag) {
                return "#" + this.location.toString();
            }
            return this.location.toString();
        }
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceOrTagKeyArgument<T>, Template> {
        public void serializeToJson(Template template, JsonObject json) {
            if (template.registry != null) {
                json.addProperty("registry", template.registry.m_135782_().toString());
            }
        }

        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            if (template.registry != null) {
                buffer.m_130085_(template.registry.m_135782_());
            } else {
                buffer.m_130070_("");
            }
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            String str = buffer.m_130136_(Short.MAX_VALUE);
            if (str.isEmpty()) {
                return new Template(null);
            }
            return new Template(ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(str)));
        }

        public Template unpack(ResourceOrTagKeyArgument<T> argument) {
            return new Template(argument.registry);
        }

        public class Template
        implements ArgumentTypeInfo.Template<ResourceOrTagKeyArgument<T>> {
            @Nullable
            private final ResourceKey<? extends Registry<T>> registry;

            public ResourceOrTagKeyArgument<T> instantiate(CommandBuildContext commandBuildContext) {
                return new ResourceOrTagKeyArgument(this.registry);
            }

            public ArgumentTypeInfo<ResourceOrTagKeyArgument<T>, ?> m_213709_() {
                return Info.this;
            }

            public Template(ResourceKey<? extends Registry<T>> registry) {
                this.registry = registry;
            }
        }
    }
}

