/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import org.joml.Vector3f;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public enum Vector3fLoadable implements RecordLoadable<Vector3f>
{
    INSTANCE;


    @Override
    public Vector3f convert(JsonElement element, String key, TypedMap context) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            if (array.size() != 3) {
                throw new JsonParseException("Expected " + key + " to be size 3, found " + array.size());
            }
            return new Vector3f(GsonHelper.m_13888_((JsonElement)array.get(0), (String)(key + "[0]")), GsonHelper.m_13888_((JsonElement)array.get(1), (String)(key + "[1]")), GsonHelper.m_13888_((JsonElement)array.get(2), (String)(key + "[2]")));
        }
        return this.deserialize(GsonHelper.m_13918_((JsonElement)element, (String)key), context);
    }

    @Override
    public Vector3f deserialize(JsonObject json, TypedMap context) {
        return new Vector3f(GsonHelper.m_13915_((JsonObject)json, (String)"x"), GsonHelper.m_13915_((JsonObject)json, (String)"y"), GsonHelper.m_13915_((JsonObject)json, (String)"z"));
    }

    @Override
    public JsonElement serialize(Vector3f vector) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(vector.x()));
        array.add((Number)Float.valueOf(vector.y()));
        array.add((Number)Float.valueOf(vector.z()));
        return array;
    }

    @Override
    public void serialize(Vector3f vector, JsonObject json) {
        if (vector.x != 0.0f) {
            json.addProperty("x", (Number)Float.valueOf(vector.x));
        }
        if (vector.y != 0.0f) {
            json.addProperty("y", (Number)Float.valueOf(vector.y));
        }
        if (vector.z != 0.0f) {
            json.addProperty("z", (Number)Float.valueOf(vector.z));
        }
    }

    @Override
    public Vector3f decode(FriendlyByteBuf buffer, TypedMap context) {
        return buffer.m_269394_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Vector3f value) {
        buffer.m_269582_(value);
    }
}

