/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.network.packet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.OffhandCooldownTracker;

public class SwingArmPacket
implements IThreadsafePacket {
    private final int entityId;
    private final InteractionHand hand;

    public SwingArmPacket(Entity entity, InteractionHand hand) {
        this.entityId = entity.m_19879_();
        this.hand = hand;
    }

    public SwingArmPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.m_130242_();
        this.hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.m_130068_((Enum)this.hand);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(SwingArmPacket packet) {
            Entity entity;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && (entity = world.m_6815_(packet.entityId)) instanceof LivingEntity) {
                OffhandCooldownTracker.swingHand((LivingEntity)entity, packet.hand, false);
            }
        }
    }
}

