/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import slimeknights.mantle.recipe.MantleRecipes;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RetexturedHelper;

public class ShapedRetexturedRecipe
extends ShapedRecipe {
    private final Ingredient texture;
    private final boolean matchAll;

    protected ShapedRetexturedRecipe(ShapedRecipe orig, Ingredient texture, boolean matchAll) {
        super(orig.m_6423_(), orig.m_6076_(), orig.m_245232_(), orig.m_44220_(), orig.m_44221_(), orig.m_7527_(), orig.f_44149_);
        this.texture = texture;
        this.matchAll = matchAll;
    }

    public ItemStack getResultItem(Item texture, RegistryAccess access) {
        return RetexturedHelper.setTexture(this.m_8043_(access).m_41777_(), Block.m_49814_((Item)texture));
    }

    public ItemStack m_5874_(CraftingContainer craftMatrix, RegistryAccess access) {
        ItemStack result = super.m_5874_(craftMatrix, access);
        Block currentTexture = null;
        for (int i = 0; i < craftMatrix.m_6643_(); ++i) {
            Block block;
            ItemStack stack = craftMatrix.m_8020_(i);
            if (stack.m_41619_() || !this.texture.test(stack) || (block = stack.m_41720_() == result.m_41720_() ? RetexturedHelper.getTexture(stack) : Block.m_49814_((Item)stack.m_41720_())) == Blocks.f_50016_) continue;
            if (currentTexture == null) {
                currentTexture = block;
                if (this.matchAll) continue;
                break;
            }
            if (currentTexture == block) continue;
            currentTexture = null;
            break;
        }
        if (currentTexture != null) {
            return RetexturedHelper.setTexture(result, currentTexture);
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MantleRecipes.CRAFTING_SHAPED_RETEXTURED.get();
    }

    public Ingredient getTexture() {
        return this.texture;
    }

    public static class Serializer
    implements LoggingRecipeSerializer<ShapedRetexturedRecipe> {
        public ShapedRetexturedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)f_44076_.m_6729_(recipeId, json);
            Ingredient texture = CraftingHelper.getIngredient((JsonElement)JsonHelper.getElement(json, "texture"), (boolean)false);
            boolean matchAll = false;
            if (json.has("match_all")) {
                matchAll = json.get("match_all").getAsBoolean();
            }
            return new ShapedRetexturedRecipe(recipe, texture, matchAll);
        }

        @Override
        @Nullable
        public ShapedRetexturedRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)f_44076_.m_8005_(recipeId, buffer);
            return recipe == null ? null : new ShapedRetexturedRecipe(recipe, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readBoolean());
        }

        @Override
        public void toNetworkSafe(FriendlyByteBuf buffer, ShapedRetexturedRecipe recipe) {
            f_44076_.m_6178_(buffer, (Recipe)recipe);
            recipe.texture.m_43923_(buffer);
            buffer.writeBoolean(recipe.matchAll);
        }
    }
}

