/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.common.BlockStateLoadable;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.mantle.network.packet.ISimplePacket;

public class JsonHelper {
    public static final Gson DEFAULT_GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();

    private JsonHelper() {
    }

    public static JsonElement getElement(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return json.get(memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    public static <T> List<T> parseList(JsonArray array, String name, Loadable<T> mapper) {
        if (array.isEmpty()) {
            throw new JsonSyntaxException(name + " must have at least 1 element");
        }
        ArrayList<T> builder = new ArrayList<T>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            builder.add(mapper.convert(array.get(i), name + "[" + i + "]"));
        }
        return List.copyOf(builder);
    }

    public static <T> List<T> parseList(JsonObject parent, String name, Loadable<T> mapper) {
        return JsonHelper.parseList(GsonHelper.m_13933_((JsonObject)parent, (String)name), name, mapper);
    }

    public static <T> List<T> parseList(JsonArray array, String name, BiFunction<JsonElement, String, T> mapper) {
        if (array.isEmpty()) {
            throw new JsonSyntaxException(name + " must have at least 1 element");
        }
        ArrayList<T> builder = new ArrayList<T>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            builder.add(mapper.apply(array.get(i), name + "[" + i + "]"));
        }
        return List.copyOf(builder);
    }

    @Deprecated
    public static <T> List<T> parseList(JsonArray array, String name, Function<JsonObject, T> mapper) {
        return JsonHelper.parseList(array, name, (JsonElement element, String s) -> mapper.apply(GsonHelper.m_13918_((JsonElement)element, (String)s)));
    }

    public static <T> List<T> parseList(JsonObject parent, String name, BiFunction<JsonElement, String, T> mapper) {
        return JsonHelper.parseList(GsonHelper.m_13933_((JsonObject)parent, (String)name), name, mapper);
    }

    @Deprecated
    public static <T> List<T> parseList(JsonObject parent, String name, Function<JsonObject, T> mapper) {
        return JsonHelper.parseList(GsonHelper.m_13933_((JsonObject)parent, (String)name), name, mapper);
    }

    public static ResourceLocation getResourceLocation(JsonObject json, String key) {
        String text = GsonHelper.m_13906_((JsonObject)json, (String)key);
        ResourceLocation location = ResourceLocation.m_135820_((String)text);
        if (location == null) {
            throw new JsonSyntaxException("Expected " + key + " to be a Resource location, was '" + text + "'");
        }
        return location;
    }

    @Nullable
    @Contract(value="_,_,!null -> !null")
    public static ResourceLocation getResourceLocation(JsonObject json, String key, @Nullable ResourceLocation fallback) {
        if (json.has(key)) {
            return JsonHelper.getResourceLocation(json, key);
        }
        return fallback;
    }

    public static ResourceLocation convertToResourceLocation(JsonElement json, String key) {
        String text = GsonHelper.m_13805_((JsonElement)json, (String)key);
        ResourceLocation location = ResourceLocation.m_135820_((String)text);
        if (location == null) {
            throw new JsonSyntaxException("Expected " + key + " to be a resource location, was '" + text + "'");
        }
        return location;
    }

    @Deprecated(forRemoval=true)
    public static <T> T convertToEntry(IForgeRegistry<T> registry, JsonElement element, String key) {
        Object value;
        ResourceLocation name = JsonHelper.convertToResourceLocation(element, key);
        if (registry.containsKey(name) && (value = registry.getValue(name)) != null) {
            return (T)value;
        }
        throw new JsonSyntaxException("Unknown " + registry.getRegistryName() + " " + name);
    }

    @Deprecated(forRemoval=true)
    public static <T> T getAsEntry(IForgeRegistry<T> registry, JsonObject parent, String key) {
        return JsonHelper.convertToEntry(registry, JsonHelper.getElement(parent, key), key);
    }

    private static <T extends Enum<T>> T enumByName(String name, Class<T> enumClass) {
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            if (!value.name().toLowerCase(Locale.ROOT).equals(name)) continue;
            return (T)value;
        }
        throw new JsonSyntaxException("Invalid " + enumClass.getSimpleName() + " " + name);
    }

    @Deprecated(forRemoval=true)
    public static <T extends Enum<T>> T convertToEnum(JsonElement element, String key, Class<T> enumClass) {
        String name = GsonHelper.m_13805_((JsonElement)element, (String)key);
        return JsonHelper.enumByName(name, enumClass);
    }

    @Deprecated(forRemoval=true)
    public static <T extends Enum<T>> T getAsEnum(JsonObject json, String key, Class<T> enumClass) {
        String name = GsonHelper.m_13906_((JsonObject)json, (String)key);
        return JsonHelper.enumByName(name, enumClass);
    }

    @Nullable
    public static JsonObject getJson(Resource resource, ResourceLocation location) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                jsonObject = GsonHelper.m_13859_((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    Mantle.logger.error("Failed to load JSON from resource {} from pack '{}'", (Object)location, (Object)resource.m_215506_(), (Object)e);
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }

    public static List<JsonObject> getFileInAllDomainsAndPacks(ResourceManager manager, String path, @Nullable String preferredPath) {
        return manager.m_7187_().stream().filter(ResourceLocation::m_135843_).flatMap(namespace -> {
            ResourceLocation location = new ResourceLocation(namespace, path);
            return manager.m_213829_(location).stream().map(preferredPath != null ? resource -> {
                Mantle.logger.warn("Using deprecated path {} in pack {} - use {}:{} instead", (Object)location, (Object)resource.m_215506_(), (Object)location.m_135827_(), (Object)preferredPath);
                return JsonHelper.getJson(resource, location);
            } : resource -> JsonHelper.getJson(resource, location));
        }).filter(Objects::nonNull).toList();
    }

    private static void sendPackets(NetworkWrapper network, ServerPlayer player, ISimplePacket[] packets) {
        if (!player.f_8906_.f_9742_.m_129531_()) {
            PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> player);
            for (ISimplePacket packet : packets) {
                network.send(target, packet);
            }
        }
    }

    public static void syncPackets(OnDatapackSyncEvent event, NetworkWrapper network, ISimplePacket ... packets) {
        ServerPlayer targetedPlayer = event.getPlayer();
        if (targetedPlayer != null) {
            JsonHelper.sendPackets(network, targetedPlayer, packets);
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                JsonHelper.sendPackets(network, player, packets);
            }
        }
    }

    public static String localize(String path, String folder, String extension) {
        return path.substring(folder.length() + 1, path.length() - extension.length());
    }

    public static ResourceLocation localize(ResourceLocation location, String folder, String extension) {
        return location.m_247449_(JsonHelper.localize(location.m_135815_(), folder, extension));
    }

    public static ResourceLocation wrap(ResourceLocation location, String prefix, String suffix) {
        return location.m_247449_(prefix + location.m_135815_() + suffix);
    }

    public static <T> T parse(Codec<T> codec, Reader reader) throws JsonParseException {
        return JsonHelper.parse(codec, (JsonElement)GsonHelper.m_13859_((Reader)reader));
    }

    public static <T> T parse(Codec<T> codec, JsonElement json) throws JsonParseException {
        return (T)codec.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json)).getOrThrow(false, arg_0 -> ((Logger)Mantle.logger).error(arg_0));
    }

    public static <T> JsonElement serialize(Codec<T> codec, T object) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(false, arg_0 -> ((Logger)Mantle.logger).error(arg_0));
    }

    @Deprecated(forRemoval=true)
    public static BlockState convertToBlockState(JsonElement element, String key) {
        return (BlockState)BlockStateLoadable.DIFFERENCE.convert(element, key);
    }

    @Deprecated(forRemoval=true)
    public static BlockState getAsBlockState(JsonObject parent, String key) {
        return (BlockState)BlockStateLoadable.DIFFERENCE.getIfPresent(parent, key);
    }

    @Deprecated(forRemoval=true)
    public static BlockState convertToBlockState(JsonObject json) {
        return (BlockState)BlockStateLoadable.DIFFERENCE.deserialize(json);
    }

    @Deprecated(forRemoval=true)
    public static JsonElement serializeBlockState(BlockState state) {
        return BlockStateLoadable.DIFFERENCE.serialize(state);
    }

    @Deprecated(forRemoval=true)
    public static JsonObject serializeBlockState(BlockState state, JsonObject json) {
        BlockStateLoadable.DIFFERENCE.serialize(state, json);
        return json;
    }
}

