/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record HorizontalComponent(boolean oppose) implements KBlockComponent
{
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final HorizontalComponent NORMAL = new HorizontalComponent(false);
    private static final HorizontalComponent OPPOSE = new HorizontalComponent(true);
    public static final MapCodec<HorizontalComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("oppose", (Object)false).forGetter(HorizontalComponent::oppose)).apply((Applicative)instance, HorizontalComponent::getInstance));

    public static HorizontalComponent getInstance(boolean oppose) {
        return oppose ? OPPOSE : NORMAL;
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.HORIZONTAL.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.NORTH);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        if (settings.customPlacement) {
            return state;
        }
        Direction firstDirection = context.m_8125_();
        Iterable directions = Iterables.concat(List.of(firstDirection), List.of(context.m_6232_()));
        int index = 0;
        for (Direction direction : directions) {
            BlockState blockstate;
            if (direction.m_122434_().m_122478_() || ++index > 1 && direction == firstDirection || !(blockstate = (BlockState)state.m_61124_((Property)FACING, (Comparable)(this.oppose ? direction : direction.m_122424_()))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    @Override
    public Direction getHorizontalFacing(BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        return this.oppose ? direction.m_122424_() : direction;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

