/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.brewincompatdelight;

import com.draconicarcher.brewincompatdelight.Config;
import com.draconicarcher.brewincompatdelight.blocks.BCDBlocks;
import com.draconicarcher.brewincompatdelight.events.ExpBoostHandler;
import com.draconicarcher.brewincompatdelight.events.HurricaneHandler;
import com.draconicarcher.brewincompatdelight.integration.ThirstWasTakenIntegration;
import com.draconicarcher.brewincompatdelight.items.BCDFluids;
import com.draconicarcher.brewincompatdelight.items.BCDFood;
import com.draconicarcher.brewincompatdelight.items.BCDItems;
import com.draconicarcher.brewincompatdelight.loot.ModLootModifiers;
import com.draconicarcher.brewincompatdelight.registries.BCDModEffects;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="brewincompatdelight")
public class Brewincompatdelight {
    public static final String MODID = "brewincompatdelight";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"brewincompatdelight");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"brewincompatdelight");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"brewincompatdelight");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"brewincompatdelight");
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"brewincompatdelight");

    public Brewincompatdelight() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLootModifiers.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new ExpBoostHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HurricaneHandler());
        BCDFluids.register(modEventBus);
        BCDModEffects.register(modEventBus);
        BCDBlocks.register(modEventBus);
        BCDItems.initialize();
        BCDItems.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        SERIALIZERS.register(modEventBus);
        BCDFood.initialize();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        if (ModList.get().isLoaded("thirst")) {
            MinecraftForge.EVENT_BUS.register(ThirstWasTakenIntegration.class);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        event.enqueueWork(() -> {
            ComposterBlock.f_51914_.put((Object)((ItemLike)BCDItems.JUNIPER_BERRIES.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)BCDItems.RED_GRAPES.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)BCDItems.WHITE_GRAPES.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)BCDItems.RED_GRAPE_SEEDS.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)BCDItems.WHITE_GRAPE_SEEDS.get()), 0.3f);
        });
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256839_) {
            this.addItemToTab(event, BCDItems.MOONSHINE);
            this.addItemToTab(event, BCDItems.WHITE_WINE);
            this.addItemToTab(event, BCDItems.RED_WINE);
            this.addItemToTab(event, BCDItems.SWEET_RED_WINE);
            this.addItemToTab(event, BCDItems.HALF_AND_HALF);
            this.addItemToTab(event, BCDItems.BLACK_RUSSIAN);
            this.addItemToTab(event, BCDItems.WHITE_RUSSIAN);
            this.addItemToTab(event, BCDItems.SCREWDRIVER);
            this.addItemToTab(event, BCDItems.TEQUILA);
            this.addItemToTab(event, BCDItems.MULLED_WINE);
            this.addItemToTab(event, BCDItems.PEACH_WINE);
            this.addItemToTab(event, BCDItems.NUT_BROWN_ALE);
            this.addItemToTab(event, BCDItems.LEMON_LIME);
            this.addItemToTab(event, BCDItems.HARD_CIDER);
            this.addItemToTab(event, BCDItems.HARD_LEMONADE);
            this.addItemToTab(event, BCDItems.RUM);
            this.addItemToTab(event, BCDItems.MOJITO);
            this.addItemToTab(event, BCDItems.PINA_COLADA);
            this.addItemToTab(event, BCDItems.WHISKEY);
            this.addItemToTab(event, BCDItems.MARGARITA);
            this.addItemToTab(event, BCDItems.SALTED_MARGARITA);
            this.addItemToTab(event, BCDItems.BOILERMAKER);
            this.addItemToTab(event, BCDItems.TEQUILA_SUNRISE);
            this.addItemToTab(event, BCDItems.KRAKEN_RUM);
            this.addItemToTab(event, BCDItems.JUNIPER_BERRIES);
            this.addItemToTab(event, BCDItems.GIN);
            this.addItemToTab(event, BCDItems.BLUE_CURACAO);
            this.addItemToTab(event, BCDItems.TONIC_WATER);
            this.addItemToTab(event, BCDItems.GRENADINE);
            this.addItemToTab(event, BCDItems.WHISKEY_SOUR);
            this.addItemToTab(event, BCDItems.CHINA_BLUE);
            this.addItemToTab(event, BCDItems.SINGAPORE_SLING);
            this.addItemToTab(event, BCDItems.AQUA_VELVA);
            this.addItemToTab(event, BCDItems.GIN_AND_TONIC);
            this.addItemToTab(event, BCDItems.MERMAID_LEMONADE);
            this.addItemToTab(event, BCDItems.BEES_KNEES);
            this.addItemToTab(event, BCDItems.GIMLET);
            this.addItemToTab(event, BCDItems.BRASS_MONKEY);
            this.addItemToTab(event, BCDItems.VODKA_TONIC);
            this.addItemToTab(event, BCDItems.GIN_AND_JUICE);
            this.addItemToTab(event, BCDItems.JOHNNY_SILVERHAND);
            this.addItemToTab(event, BCDItems.MEDINA);
            this.addItemToTab(event, BCDItems.RED_GRAPE_SEEDS);
            this.addItemToTab(event, BCDItems.WHITE_GRAPE_SEEDS);
            this.addItemToTab(event, BCDItems.RED_GRAPES);
            this.addItemToTab(event, BCDItems.WHITE_GRAPES);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            this.addItemToTab(event, BCDItems.SOY_WAX);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256839_) {
            event.m_246326_((ItemLike)((Block)BCDBlocks.JUNIPER_BERRIES_CRATE.get()).m_5456_());
            event.m_246326_((ItemLike)((Block)BCDBlocks.RED_GRAPES_CRATE.get()).m_5456_());
            event.m_246326_((ItemLike)((Block)BCDBlocks.WHITE_GRAPES_CRATE.get()).m_5456_());
        }
    }

    private void addItemToTab(BuildCreativeModeTabContentsEvent event, RegistryObject<Item> item) {
        if (item != null && item.get() != null) {
            event.m_246326_((ItemLike)item.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="brewincompatdelight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }
    }
}

