/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.mixin;

import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.api.config.TagPair;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import dev.imb11.sounds.dynamic.TagPairHelper;
import dev.imb11.sounds.util.BlockAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={Block.class})
public abstract class BlockSoundMixin
implements BlockAccessor {
    @Unique
    @Nullable
    private TagPair associatedTagPair = null;
    @Unique
    private boolean hasFetched = false;

    @Override
    public void sounds$prepareTagPair(ResourceLocation value) {
        try {
            TagPair pair;
            if (Minecraft.m_91087_() == null) {
                return;
            }
            if (this instanceof LiquidBlock) {
                this.hasFetched = true;
                return;
            }
            if (SoundsConfig.get(WorldSoundsConfig.class).disableBlocksEntirely) {
                return;
            }
            this.associatedTagPair = pair = TagPairHelper.get(value);
            this.hasFetched = true;
        }
        catch (Exception ignored) {
            SoundsClient.LOGGER.warn("Early-load attempt at getting custom sound block group failed. Ignoring for now.");
        }
    }

    @Inject(method={"getSoundGroup"}, at={@At(value="HEAD")}, cancellable=true)
    public void $manageCustomSounds(BlockState state, CallbackInfoReturnable<SoundType> cir) {
        try {
            if (!this.hasFetched) {
                this.sounds$prepareTagPair(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()));
            }
            if (SoundsConfig.get(WorldSoundsConfig.class).disableBlocksEntirely) {
                return;
            }
        }
        catch (Exception ignored) {
            SoundsClient.LOGGER.warn("Failed initial block fetch.");
        }
        if (this.associatedTagPair != null) {
            cir.setReturnValue((Object)this.associatedTagPair.getGroup());
        }
    }
}

