/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers.screenparticle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;

public class ParticleEmitterHandler {
    public static final Map<Item, List<ItemParticleSupplier>> EMITTERS = new HashMap<Item, List<ItemParticleSupplier>>();

    public static void registerParticleEmitters(FMLClientSetupEvent event) {
        DataHelper.getAll(ForgeRegistries.ITEMS.getValues(), i -> i instanceof ItemParticleSupplier).forEach(i -> {
            ItemParticleSupplier emitter = (ItemParticleSupplier)i;
            ParticleEmitterHandler.registerItemParticleEmitter(i, emitter);
        });
    }

    public static void registerItemParticleEmitter(Item item, ItemParticleSupplier emitter) {
        if (EMITTERS.containsKey(item)) {
            EMITTERS.get(item).add(emitter);
        } else {
            EMITTERS.put(item, new ArrayList<ItemParticleSupplier>(List.of(emitter)));
        }
    }

    public static void registerItemParticleEmitter(ItemParticleSupplier emitter, Item ... items) {
        for (Item item : items) {
            ParticleEmitterHandler.registerItemParticleEmitter(item, emitter);
        }
    }

    public static interface ItemParticleSupplier {
        default public void spawnEarlyParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        }

        default public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        }
    }
}

