/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlockHelper {
    public static BlockState getBlockStateWithExistingProperties(BlockState oldState, BlockState newState) {
        BlockState finalState = newState;
        for (Property property : oldState.m_61147_()) {
            if (!newState.m_61138_(property)) continue;
            finalState = BlockHelper.newStateWithOldProperty(oldState, finalState, property);
        }
        return finalState;
    }

    public static BlockState setBlockStateWithExistingProperties(Level level, BlockPos pos, BlockState newState, int flags) {
        BlockState oldState = level.m_8055_(pos);
        BlockState finalState = BlockHelper.getBlockStateWithExistingProperties(oldState, newState);
        level.m_7260_(pos, oldState, finalState, flags);
        level.m_7731_(pos, finalState, flags);
        return finalState;
    }

    public static <T extends Comparable<T>> BlockState newStateWithOldProperty(BlockState oldState, BlockState newState, Property<T> property) {
        return (BlockState)newState.m_61124_(property, oldState.m_61143_(property));
    }

    public static CompoundTag saveBlockPos(CompoundTag compoundNBT, BlockPos pos) {
        compoundNBT.m_128405_("X", pos.m_123341_());
        compoundNBT.m_128405_("Y", pos.m_123342_());
        compoundNBT.m_128405_("Z", pos.m_123343_());
        return compoundNBT;
    }

    public static CompoundTag saveBlockPos(CompoundTag compoundNBT, BlockPos pos, String extra) {
        compoundNBT.m_128405_(extra + "_X", pos.m_123341_());
        compoundNBT.m_128405_(extra + "_Y", pos.m_123342_());
        compoundNBT.m_128405_(extra + "_Z", pos.m_123343_());
        return compoundNBT;
    }

    public static BlockPos loadBlockPos(CompoundTag tag) {
        return tag.m_128441_("X") ? new BlockPos(tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128451_("Z")) : null;
    }

    public static BlockPos loadBlockPos(CompoundTag tag, String extra) {
        return tag.m_128441_(extra + "_X") ? new BlockPos(tag.m_128451_(extra + "_X"), tag.m_128451_(extra + "_Y"), tag.m_128451_(extra + "_Z")) : null;
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int range, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, range, predicate).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, Level level, BlockPos pos, int range, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, range, range, range, predicate);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x, int z, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, z, predicate).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, Level level, BlockPos pos, int x, int z, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, z).filter(predicate);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x, int y, int z, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, y, z, predicate).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, Level level, BlockPos pos, int x, int y, int z, Predicate<T> predicate) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, y, z).filter(predicate);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int range) {
        return BlockHelper.getBlockEntities(type, level, pos, range, range, range);
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, Level level, BlockPos pos, int range) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, range, range, range);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x, int z) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, z).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, Level level, BlockPos pos, int x, int z) {
        return BlockHelper.getBlockEntitiesStream(type, level, new AABB((double)pos.m_123341_() - (double)x, (double)pos.m_123342_(), (double)pos.m_123343_() - (double)z, (double)pos.m_123341_() + (double)x, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + (double)z));
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x, int y, int z) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x, y, z).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, Level level, BlockPos pos, int x, int y, int z) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, -x, -y, -z, x, y, z);
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, Level level, BlockPos pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockHelper.getBlockEntitiesStream(type, level, pos, x1, y1, z1, x2, y2, z2).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, Level level, BlockPos pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockHelper.getBlockEntitiesStream(type, level, new AABB((double)pos.m_123341_() + 1.5 + (double)x1, (double)pos.m_123342_() + 1.5 + (double)y1, (double)pos.m_123343_() + 1.5 + (double)z1, (double)pos.m_123341_() + 0.5 + (double)x2, (double)pos.m_123342_() + 0.5 + (double)y2, (double)pos.m_123343_() + 0.5 + (double)z2));
    }

    public static <T> Collection<T> getBlockEntities(Class<T> type, Level world, AABB bb) {
        return BlockHelper.getBlockEntitiesStream(type, world, bb).collect(Collectors.toSet());
    }

    public static <T> Stream<T> getBlockEntitiesStream(Class<T> type, Level world, AABB bb) {
        return IntStream.iterate((int)Math.floor(bb.f_82288_), i -> (double)i < Math.ceil(bb.f_82291_) + 16.0, i -> i + 16).boxed().flatMap(i -> IntStream.iterate((int)Math.floor(bb.f_82290_), j -> (double)j < Math.ceil(bb.f_82293_) + 16.0, j -> j + 16).boxed().flatMap(j -> {
            ChunkAccess c = world.m_46865_(new BlockPos(i.intValue(), 0, j.intValue()));
            return c.m_5928_().stream();
        })).filter(p -> bb.m_82393_((double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5)).map(arg_0 -> ((Level)world).m_7702_(arg_0)).filter(type::isInstance).map(type::cast);
    }

    public static Collection<BlockPos> getBlocks(BlockPos pos, int range, Predicate<BlockPos> predicate) {
        return BlockHelper.getBlocksStream(pos, range, predicate).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getBlocksStream(BlockPos pos, int range, Predicate<BlockPos> predicate) {
        return BlockHelper.getBlocksStream(pos, range, range, range, predicate);
    }

    public static Collection<BlockPos> getBlocks(BlockPos pos, int x, int y, int z, Predicate<BlockPos> predicate) {
        return BlockHelper.getBlocksStream(pos, x, y, z, predicate).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getBlocksStream(BlockPos pos, int x, int y, int z, Predicate<BlockPos> predicate) {
        return BlockHelper.getBlocksStream(pos, x, y, z).filter(predicate);
    }

    public static Collection<BlockPos> getBlocks(BlockPos pos, int x, int y, int z) {
        return BlockHelper.getBlocksStream(pos, x, y, z).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getBlocksStream(BlockPos pos, int x, int y, int z) {
        return BlockHelper.getBlocksStream(pos, -x, -y, -z, x, y, z);
    }

    public static Collection<BlockPos> getBlocks(BlockPos pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return BlockHelper.getBlocksStream(pos, x1, y1, z1, x2, y2, z2).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getBlocksStream(BlockPos pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        return IntStream.rangeClosed(x1, x2).boxed().flatMap(i -> IntStream.rangeClosed(y1, y2).boxed().flatMap(j -> IntStream.rangeClosed(z1, z2).boxed().map(k -> pos.m_7918_(i.intValue(), j.intValue(), k.intValue()))));
    }

    public static Collection<BlockPos> getPlaneOfBlocks(BlockPos pos, int range, Predicate<BlockPos> predicate) {
        return BlockHelper.getPlaneOfBlocksStream(pos, range, predicate).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getPlaneOfBlocksStream(BlockPos pos, int range, Predicate<BlockPos> predicate) {
        return BlockHelper.getPlaneOfBlocksStream(pos, range, range, predicate);
    }

    public static Collection<BlockPos> getPlaneOfBlocks(BlockPos pos, int x, int z, Predicate<BlockPos> predicate) {
        return BlockHelper.getPlaneOfBlocksStream(pos, x, z, predicate).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getPlaneOfBlocksStream(BlockPos pos, int x, int z, Predicate<BlockPos> predicate) {
        return BlockHelper.getPlaneOfBlocksStream(pos, x, z).filter(predicate);
    }

    public static Collection<BlockPos> getPlaneOfBlocks(BlockPos pos, int x, int z) {
        return BlockHelper.getPlaneOfBlocksStream(pos, x, z).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getPlaneOfBlocksStream(BlockPos pos, int x, int z) {
        return BlockHelper.getPlaneOfBlocksStream(pos, -x, -z, x, z);
    }

    public static Collection<BlockPos> getPlaneOfBlocks(BlockPos pos, int x1, int z1, int x2, int z2) {
        return BlockHelper.getPlaneOfBlocksStream(pos, x1, z1, x2, z2).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getPlaneOfBlocksStream(BlockPos pos, int x1, int z1, int x2, int z2) {
        return IntStream.rangeClosed(x1, x2).boxed().flatMap(x -> IntStream.rangeClosed(z1, z2).boxed().map(z -> pos.m_7918_(x.intValue(), 0, z.intValue())));
    }

    public static Collection<BlockPos> getSphereOfBlocks(BlockPos pos, float range, Predicate<BlockPos> predicate) {
        return BlockHelper.getSphereOfBlocksStream(pos, range, predicate).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getSphereOfBlocksStream(BlockPos pos, float range, Predicate<BlockPos> predicate) {
        return BlockHelper.getSphereOfBlocksStream(pos, range, range).filter(predicate);
    }

    public static Collection<BlockPos> getSphereOfBlocks(BlockPos pos, float width, float height, Predicate<BlockPos> predicate) {
        return BlockHelper.getSphereOfBlocksStream(pos, width, height, predicate).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getSphereOfBlocksStream(BlockPos pos, float width, float height, Predicate<BlockPos> predicate) {
        return BlockHelper.getSphereOfBlocksStream(pos, width, height).filter(predicate);
    }

    public static Collection<BlockPos> getSphereOfBlocks(BlockPos pos, float range) {
        return BlockHelper.getSphereOfBlocksStream(pos, range).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getSphereOfBlocksStream(BlockPos pos, float range) {
        return BlockHelper.getSphereOfBlocksStream(pos, range, range);
    }

    public static Collection<BlockPos> getSphereOfBlocks(BlockPos pos, float width, float height) {
        return BlockHelper.getSphereOfBlocksStream(pos, width, height).collect(Collectors.toSet());
    }

    public static Stream<BlockPos> getSphereOfBlocksStream(BlockPos pos, float width, float height) {
        return IntStream.rangeClosed((int)(-width), (int)width).boxed().flatMap(x -> IntStream.rangeClosed((int)(-height), (int)height).boxed().flatMap(y -> IntStream.rangeClosed((int)(-width), (int)width).boxed().filter(z -> {
            double d = Math.sqrt(x * x + y * y + z * z);
            return d <= (double)width;
        }).map(z -> pos.m_7918_(x.intValue(), y.intValue(), z.intValue()))));
    }

    public static Collection<BlockPos> getNeighboringBlocks(BlockPos current) {
        return BlockHelper.getBlocks(current, -1, -1, -1, 1, 1, 1);
    }

    public static Stream<BlockPos> getNeighboringBlocksStream(BlockPos current) {
        return BlockHelper.getBlocksStream(current, -1, -1, -1, 1, 1, 1);
    }

    public static Collection<BlockPos> getPath(BlockPos start, BlockPos end, int speed, boolean inclusive, Level level) {
        Parrot parrot = new Parrot(EntityType.f_20508_, level);
        parrot.m_6034_((double)start.m_123341_() + 0.5, (double)start.m_123342_() - 0.5, (double)start.m_123343_() + 0.5);
        parrot.m_21573_().m_26519_((double)end.m_123341_() + 0.5, (double)end.m_123342_() - 0.5, (double)end.m_123343_() + 0.5, (double)speed);
        Path path = parrot.m_21573_().m_26570_();
        parrot.m_146870_();
        int nodes = path != null ? path.m_77398_() : 0;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int i = 0; i < nodes; ++i) {
            Node node = path.m_77375_(i);
            positions.add(new BlockPos(node.f_77271_, (int)((double)node.f_77272_ - 0.5), node.f_77273_));
        }
        if (!inclusive) {
            positions.remove(0);
            positions.remove(positions.size() - 1);
        }
        return positions;
    }

    public static void updateState(Level level, BlockPos pos) {
        BlockHelper.updateState(level.m_8055_(pos), level, pos);
    }

    public static void updateState(BlockState state, Level level, BlockPos pos) {
        level.m_7260_(pos, state, state, 2);
        level.m_151543_(pos);
    }

    public static void updateAndNotifyState(Level level, BlockPos pos) {
        BlockHelper.updateAndNotifyState(level.m_8055_(pos), level, pos);
    }

    public static void updateAndNotifyState(BlockState state, Level level, BlockPos pos) {
        BlockHelper.updateState(state, level, pos);
        state.m_60701_((LevelAccessor)level, pos, 2);
        level.m_46717_(pos, state.m_60734_());
    }

    public static Vec3 fromBlockPos(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static Vec3 withinBlock(Random rand, BlockPos pos) {
        double x = (double)pos.m_123341_() + rand.nextDouble();
        double y = (double)pos.m_123342_() + rand.nextDouble();
        double z = (double)pos.m_123343_() + rand.nextDouble();
        return new Vec3(x, y, z);
    }
}

