/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.registry.common.LodestoneBlockEntityRegistry;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;

public class MultiBlockComponentEntity
extends LodestoneBlockEntity {
    public BlockPos corePos;

    public MultiBlockComponentEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public MultiBlockComponentEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LodestoneBlockEntityRegistry.MULTIBLOCK_COMPONENT.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        if (this.corePos != null) {
            BlockHelper.saveBlockPos(tag, this.corePos, "core_position_");
        }
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.corePos = BlockHelper.loadBlockPos(tag, "core_position_");
        super.m_142466_(tag);
    }

    @Override
    public InteractionResult onUse(Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.f_58857_.m_7702_(this.corePos)) instanceof MultiBlockCoreEntity) {
            MultiBlockCoreEntity core = (MultiBlockCoreEntity)blockEntity;
            return core.onUse(player, hand);
        }
        return super.onUse(player, hand);
    }

    @Override
    public void onBreak(@Nullable Player player) {
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.f_58857_.m_7702_(this.corePos)) instanceof MultiBlockCoreEntity) {
            MultiBlockCoreEntity core = (MultiBlockCoreEntity)blockEntity;
            core.onBreak(player);
        }
        super.onBreak(player);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.f_58857_.m_7702_(this.corePos)) instanceof MultiBlockCoreEntity) {
            MultiBlockCoreEntity core = (MultiBlockCoreEntity)blockEntity;
            return core.getCapability(cap);
        }
        return super.getCapability(cap);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.f_58857_.m_7702_(this.corePos)) instanceof MultiBlockCoreEntity) {
            MultiBlockCoreEntity core = (MultiBlockCoreEntity)blockEntity;
            return core.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }
}

