/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.screen.base;

import com.mojang.blaze3d.vertex.BufferBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

@OnlyIn(value=Dist.CLIENT)
public abstract class QuadScreenParticle
extends ScreenParticle {
    protected float quadSize;

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY) {
        super(pLevel, pX, pY);
        this.quadSize = 0.1f * (this.random.m_188501_() * 0.5f + 0.5f) * 2.0f;
    }

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY, double pXSpeed, double pYSpeed) {
        super(pLevel, pX, pY, pXSpeed, pYSpeed);
        this.quadSize = 0.1f * (this.random.m_188501_() * 0.5f + 0.5f) * 2.0f;
    }

    @Override
    public void render(BufferBuilder bufferBuilder) {
        float partialTicks = Minecraft.m_91087_().f_90991_.f_92518_;
        float size = this.getQuadSize(partialTicks) * 10.0f;
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        float roll = Mth.m_14179_((float)partialTicks, (float)this.oRoll, (float)this.roll);
        Vector3f[] vectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Quaternionf rotation = new Quaternionf(new AxisAngle4f(roll, (Vector3fc)VecHelper.Vector3fHelper.ZP));
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vectors[i];
            vector3f.rotate((Quaternionfc)rotation);
            vector3f.mul(size);
            vector3f.add((float)this.x, (float)this.y, 0.0f);
        }
        float quadZ = this.getQuadZPosition();
        bufferBuilder.m_5483_((double)vectors[0].x(), (double)vectors[0].y(), (double)quadZ).m_7421_(u1, v1).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_5752_();
        bufferBuilder.m_5483_((double)vectors[1].x(), (double)vectors[1].y(), (double)quadZ).m_7421_(u1, v0).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_5752_();
        bufferBuilder.m_5483_((double)vectors[2].x(), (double)vectors[2].y(), (double)quadZ).m_7421_(u0, v0).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_5752_();
        bufferBuilder.m_5483_((double)vectors[3].x(), (double)vectors[3].y(), (double)quadZ).m_7421_(u0, v1).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_5752_();
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize;
    }

    public float getQuadZPosition() {
        return 390.0f;
    }

    protected abstract float getU0();

    protected abstract float getU1();

    protected abstract float getV0();

    protected abstract float getV1();
}

