/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.NotNull;

public class LiquidMixer {
    public static void mixPotions(SoftFluidStack tankFluid, SoftFluidStack newFluid) {
        CompoundTag tankTag = tankFluid.getTag();
        CompoundTag newTag = newFluid.getTag();
        if (tankTag == null || newTag == null) {
            return;
        }
        int oldCount = tankFluid.getCount();
        int newCount = oldCount + newFluid.getCount();
        ArrayList<MobEffectInstance> combinedEffects = new ArrayList<MobEffectInstance>();
        List existingEffects = PotionUtils.m_43566_((CompoundTag)tankTag);
        List newEffects = PotionUtils.m_43566_((CompoundTag)newFluid.getTag());
        if (newEffects.equals(existingEffects)) {
            return;
        }
        float oldMult = (float)oldCount / (float)newCount;
        float newMult = 1.0f - oldMult;
        LiquidMixer.combineEffects(combinedEffects, existingEffects, oldMult);
        LiquidMixer.combineEffects(combinedEffects, newEffects, newMult);
        Map<MobEffect, MobEffectInstance> mergedMap = combinedEffects.stream().collect(Collectors.toMap(MobEffectInstance::m_19544_, effectInstance -> effectInstance, LiquidMixer::mergeEffects));
        mergedMap.entrySet().removeIf(e -> ((MobEffectInstance)e.getValue()).m_19557_() <= 0 || ((MobEffectInstance)e.getValue()).m_19564_() < 0);
        tankTag.m_128405_("CustomPotionColor", PotionUtils.m_43564_(mergedMap.values()));
        tankTag.m_128473_("Potion");
        LiquidMixer.saveEffects(tankTag, mergedMap.values());
    }

    @NotNull
    private static MobEffectInstance mergeEffects(MobEffectInstance e, MobEffectInstance e1) {
        return new MobEffectInstance(e.m_19544_(), e.m_19557_() + e1.m_19557_(), (e.m_19564_() + e1.m_19564_()) / 2);
    }

    public static void saveEffects(CompoundTag tag, Collection<MobEffectInstance> effects) {
        ListTag listTag = new ListTag();
        for (MobEffectInstance mobEffectInstance : effects) {
            listTag.add((Object)mobEffectInstance.m_19555_(new CompoundTag()));
        }
        if (!listTag.isEmpty()) {
            tag.m_128365_("CustomPotionEffects", (Tag)listTag);
        }
    }

    private static void combineEffects(List<MobEffectInstance> combinedEffects, List<MobEffectInstance> current, float mult) {
        for (MobEffectInstance e : current) {
            MobEffect effect = e.m_19544_();
            MobEffectInstance newInstance = effect.m_8093_() ? new MobEffectInstance(effect, e.m_19557_(), (int)((float)e.m_19564_() * mult)) : new MobEffectInstance(effect, (int)((float)e.m_19557_() * mult), e.m_19564_());
            combinedEffects.add(newInstance);
        }
    }

    public static void mixDye(SoftFluidStack tankFluid, SoftFluidStack newFluid) {
        CompoundTag tankTag = tankFluid.getTag();
        CompoundTag newTag = newFluid.getTag();
        if (tankTag == null || newTag == null) {
            return;
        }
        int oldColor = tankTag.m_128451_("color");
        int newColor = newTag.m_128451_("color");
        int oldAmount = tankFluid.getCount();
        int newAmount = newFluid.getCount();
        CompoundTag combinedTag = new CompoundTag();
        combinedTag.m_128405_("color", DyeBottleItem.mixColor(oldColor, newColor, oldAmount, newAmount));
        tankFluid.setTag(combinedTag);
    }
}

