/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;

public class LayoutSlot {
    public static final LayoutSlot EMPTY = new LayoutSlot(null, "", -1, -1, null);
    @Nullable
    private final Pattern icon;
    @Nullable
    private final String translation_key;
    private final int x;
    private final int y;
    @Nullable
    @VisibleForTesting
    private final Ingredient filter;

    public boolean isEmpty() {
        return this.getTranslationKey().isEmpty();
    }

    public boolean isHidden() {
        return this.x == -1 && this.y == -1;
    }

    public String getTranslationKey() {
        return Objects.requireNonNullElse(this.translation_key, "");
    }

    public boolean isValid(ItemStack stack) {
        return !stack.m_41619_() && (this.filter == null || this.filter.test(stack));
    }

    public static LayoutSlot read(FriendlyByteBuf buffer) {
        Pattern pattern = null;
        if (buffer.readBoolean()) {
            pattern = new Pattern(buffer.m_130281_());
        }
        String name = buffer.m_130136_(Short.MAX_VALUE);
        int x = buffer.m_130242_();
        int y = buffer.m_130242_();
        Ingredient ingredient = null;
        if (buffer.readBoolean()) {
            ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        }
        return new LayoutSlot(pattern, name, x, y, ingredient);
    }

    public void write(FriendlyByteBuf buffer) {
        if (this.icon != null) {
            buffer.writeBoolean(true);
            buffer.m_130085_((ResourceLocation)this.icon);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130070_(this.getTranslationKey());
        buffer.m_130130_(this.x);
        buffer.m_130130_(this.y);
        if (this.filter != null) {
            buffer.writeBoolean(true);
            this.filter.m_43923_(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public LayoutSlot(@Nullable Pattern icon, @Nullable String translation_key, int x, int y, @Nullable Ingredient filter) {
        this.icon = icon;
        this.translation_key = translation_key;
        this.x = x;
        this.y = y;
        this.filter = filter;
    }

    @Nullable
    public Pattern getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Nullable
    protected Ingredient getFilter() {
        return this.filter;
    }
}

