/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class RayTracer {
    public static BlockHitResult retrace(Player player, ClipContext.Fluid fluidMode) {
        return RayTracer.retrace(player, ClipContext.Block.COLLIDER, fluidMode);
    }

    public static BlockHitResult retrace(Player player, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return player.m_9236_().m_45547_(new ClipContext(RayTracer.getStartVector(player), RayTracer.getEndVector(player), blockMode, fluidMode, (Entity)player));
    }

    public static Vec3 getStartVector(Player player) {
        return RayTracer.getCorrectedHeadVector(player);
    }

    public static Vec3 getEndVector(Player player) {
        Vec3 headVec = RayTracer.getCorrectedHeadVector(player);
        Vec3 lookVec = player.m_20252_(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.m_82520_(lookVec.f_82479_ * reach, lookVec.f_82480_ * reach, lookVec.f_82481_ * reach);
    }

    public static Vec3 getCorrectedHeadVector(Player player) {
        return new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
    }

    public static double getBlockReachDistance(Player player) {
        double d;
        if (player.m_9236_().f_46443_) {
            d = ClientOnly.getBlockReachDistanceClient();
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            d = RayTracer.getBlockReachDistanceServer(serverPlayer);
        } else {
            d = 5.0;
        }
        return d;
    }

    private static double getBlockReachDistanceServer(ServerPlayer player) {
        return player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
    }

    private static class ClientOnly {
        private ClientOnly() {
        }

        private static double getBlockReachDistanceClient() {
            assert (Minecraft.m_91087_().f_91072_ != null);
            return Minecraft.m_91087_().f_91072_.m_105286_();
        }
    }
}

