/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.internal;

import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableBlock;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableBody;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableCell;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableHead;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableRow;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import dev.dediamondpro.resourcify.libs.commonmark.node.Node;
import dev.dediamondpro.resourcify.libs.commonmark.renderer.html.HtmlNodeRendererContext;
import dev.dediamondpro.resourcify.libs.commonmark.renderer.html.HtmlWriter;
import java.util.Collections;
import java.util.Map;

public class TableHtmlNodeRenderer
extends TableNodeRenderer {
    private final HtmlWriter htmlWriter;
    private final HtmlNodeRendererContext context;

    public TableHtmlNodeRenderer(HtmlNodeRendererContext context) {
        this.htmlWriter = context.getWriter();
        this.context = context;
    }

    @Override
    protected void renderBlock(TableBlock tableBlock) {
        this.htmlWriter.line();
        this.htmlWriter.tag("table", this.getAttributes(tableBlock, "table"));
        this.renderChildren(tableBlock);
        this.htmlWriter.tag("/table");
        this.htmlWriter.line();
    }

    @Override
    protected void renderHead(TableHead tableHead) {
        this.htmlWriter.line();
        this.htmlWriter.tag("thead", this.getAttributes(tableHead, "thead"));
        this.renderChildren(tableHead);
        this.htmlWriter.tag("/thead");
        this.htmlWriter.line();
    }

    @Override
    protected void renderBody(TableBody tableBody) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tbody", this.getAttributes(tableBody, "tbody"));
        this.renderChildren(tableBody);
        this.htmlWriter.tag("/tbody");
        this.htmlWriter.line();
    }

    @Override
    protected void renderRow(TableRow tableRow) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tr", this.getAttributes(tableRow, "tr"));
        this.renderChildren(tableRow);
        this.htmlWriter.tag("/tr");
        this.htmlWriter.line();
    }

    @Override
    protected void renderCell(TableCell tableCell) {
        String tagName = tableCell.isHeader() ? "th" : "td";
        this.htmlWriter.line();
        this.htmlWriter.tag(tagName, this.getCellAttributes(tableCell, tagName));
        this.renderChildren(tableCell);
        this.htmlWriter.tag("/" + tagName);
        this.htmlWriter.line();
    }

    private Map<String, String> getAttributes(Node node2, String tagName) {
        return this.context.extendAttributes(node2, tagName, Collections.emptyMap());
    }

    private Map<String, String> getCellAttributes(TableCell tableCell, String tagName) {
        if (tableCell.getAlignment() != null) {
            return this.context.extendAttributes(tableCell, tagName, Collections.singletonMap("align", TableHtmlNodeRenderer.getAlignValue(tableCell.getAlignment())));
        }
        return this.context.extendAttributes(tableCell, tagName, Collections.emptyMap());
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    private void renderChildren(Node parent) {
        Node node2 = parent.getFirstChild();
        while (node2 != null) {
            Node next = node2.getNext();
            this.context.render(node2);
            node2 = next;
        }
    }
}

