/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingRecipe;

public abstract class SmithingCategoryExtension<R extends SmithingRecipe>
implements ISmithingCategoryExtension<R> {
    private final IPlatformRecipeHelper recipeHelper;

    public SmithingCategoryExtension(IPlatformRecipeHelper recipeHelper) {
        this.recipeHelper = recipeHelper;
    }

    @Override
    public <T extends IIngredientAcceptor<T>> void setTemplate(R recipe, T ingredientAcceptor) {
        Ingredient ingredient = this.recipeHelper.getTemplate((SmithingRecipe)recipe);
        ingredientAcceptor.addIngredients(ingredient);
    }

    @Override
    public <T extends IIngredientAcceptor<T>> void setBase(R recipe, T ingredientAcceptor) {
        Ingredient ingredient = this.recipeHelper.getBase((SmithingRecipe)recipe);
        ingredientAcceptor.addIngredients(ingredient);
    }

    @Override
    public <T extends IIngredientAcceptor<T>> void setAddition(R recipe, T ingredientAcceptor) {
        Ingredient ingredient = this.recipeHelper.getAddition((SmithingRecipe)recipe);
        ingredientAcceptor.addIngredients(ingredient);
    }

    @Override
    public <T extends IIngredientAcceptor<T>> void setOutput(R recipe, T ingredientAcceptor) {
        List<ItemStack> baseStacks;
        Ingredient templateIngredient = this.recipeHelper.getTemplate((SmithingRecipe)recipe);
        Ingredient baseIngredient = this.recipeHelper.getBase((SmithingRecipe)recipe);
        Ingredient additionIngredient = this.recipeHelper.getAddition((SmithingRecipe)recipe);
        List<ItemStack> templateStacks = Arrays.asList(templateIngredient.m_43908_());
        if (templateStacks.isEmpty()) {
            templateStacks = List.of(ItemStack.f_41583_);
        }
        if ((baseStacks = Arrays.asList(baseIngredient.m_43908_())).isEmpty()) {
            baseStacks = List.of(ItemStack.f_41583_);
        }
        ItemStack addition = ItemStack.f_41583_;
        ItemStack[] additions = additionIngredient.m_43908_();
        if (additions.length > 0) {
            addition = additions[0];
        }
        for (ItemStack template : templateStacks) {
            for (ItemStack base : baseStacks) {
                Container recipeInput = SmithingCategoryExtension.createInput(template, base, addition);
                ItemStack output = RecipeUtil.assembleResultItem(recipeInput, recipe);
                ingredientAcceptor.addItemStack(output);
            }
        }
    }

    private static Container createInput(ItemStack template, ItemStack base, ItemStack addition) {
        SimpleContainer container = new SimpleContainer(3);
        container.m_6836_(0, template);
        container.m_6836_(1, base);
        container.m_6836_(2, addition);
        return container;
    }
}

