/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.gen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import noobanidus.mods.lootr.gen.LootrAtlasGenerator;
import noobanidus.mods.lootr.gen.LootrBlockTagProvider;
import noobanidus.mods.lootr.gen.LootrItemTagsProvider;
import noobanidus.mods.lootr.gen.LootrLootTableProvider;

@Mod.EventBusSubscriber(modid="lootr", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LootrDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        LootrBlockTagProvider blocks = new LootrBlockTagProvider(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blocks);
        generator.addProvider(event.includeServer(), (DataProvider)new LootrItemTagsProvider(output, provider, blocks.m_274426_(), helper));
        generator.addProvider(event.includeClient(), (DataProvider)new LootrAtlasGenerator(output, helper));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Resources for Lootr"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
        generator.addProvider(true, (DataProvider)LootrLootTableProvider.create(output));
    }
}

