/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClientAgnos;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.InitializedSupplier;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.SymbolText;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import fzzyhmstrs.emi_loot.util.stack.BlockLootEmiStack;
import fzzyhmstrs.emi_loot.util.stack.BlockStateEmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockLootRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final InitializedSupplier<EmiStack> inputStack;
    private final BlockLootEmiStack lootStack;
    private final InitializedSupplier<List<EmiStack>> outputStacks;
    private final List<WidgetRowBuilder> rowBuilderList;
    private final boolean isSimple;
    private List<EmiIngredient> inputStacks;

    public BlockLootRecipe(BlockLootRecipeData data) {
        this.id = data.id;
        this.inputStack = data.inputStack;
        this.outputStacks = data.outputStacks;
        this.rowBuilderList = data.rowBuilderList;
        this.isSimple = data.guaranteed;
        this.lootStack = new BlockLootEmiStack(data.id);
    }

    public void init() {
        this.inputStack.init();
        this.outputStacks.init();
        this.inputStacks = this.inputStack.get().getItemStack().m_41619_() ? List.of(this.lootStack) : List.of((EmiIngredient)this.inputStack.get(), this.lootStack);
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.BLOCK_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputStacks;
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks.get();
    }

    public int getDisplayWidth() {
        return EMILoot.config.isTooltipStyle() ? 144 : 160;
    }

    public int getDisplayHeight() {
        if (EMILoot.config.isTooltipStyle()) {
            int stacks = this.outputStacks.get().size();
            if (stacks <= 5) {
                return 18;
            }
            if (EMILoot.config.isCompact(EMILoot.Type.BLOCK)) {
                int ingredients = 0;
                for (WidgetRowBuilder builder : this.rowBuilderList) {
                    ingredients += builder.ingredientCount();
                }
                if (ingredients <= 4) {
                    return 29;
                }
                return 18 + 18 * ((ingredients - 5) / 8 + 1);
            }
            return 18 + 18 * ((stacks - 6) / 8 + 1);
        }
        return 23 + 29 * (this.rowBuilderList.size() - 1);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputStack.get(), 0, 0);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 0);
        int x = 46;
        int y = 0;
        if (EMILoot.config.isTooltipStyle()) {
            List stacks = this.outputStacks.get().size() <= 4 || !EMILoot.config.isCompact(EMILoot.Type.BLOCK) ? (List)this.rowBuilderList.stream().map(WidgetRowBuilder::stacks).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll) : (List)this.rowBuilderList.stream().map(WidgetRowBuilder::ingredients).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
            int i = 3;
            int j = 0;
            for (ConditionalStack stack : stacks) {
                SlotWidget widget = widgets.addSlot(stack.getIngredient(), i * 18, 18 * j).recipeContext((EmiRecipe)this);
                String rounded = FloatTrimmer.trimFloatString(Math.max(stack.weight() / 100.0f, 0.01f), (Integer)EMILoot.config.chanceDecimalPlaces.get());
                widget.appendTooltip((Component)FcText.INSTANCE.translatable("emi_loot.rolls", new Object[]{rounded}).m_130940_(ChatFormatting.GRAY));
                if (EMILoot.config.isNotPlain()) {
                    for (Tuple<Integer, Component> pair : stack.conditions()) {
                        widget.appendTooltip((Component)SymbolText.of((Integer)pair.m_14418_(), (Component)pair.m_14419_()));
                    }
                }
                if (++i <= 7) continue;
                i = 0;
                ++j;
            }
        } else {
            for (WidgetRowBuilder builder : this.rowBuilderList) {
                for (ClientBuiltPool pool : builder.getPoolList()) {
                    IconGroupEmiWidget widget = EMILootClientAgnos.createIconGroupEmiWidget(x, y, pool, this);
                    widgets.add((Widget)widget);
                    x += widget.getWidth() + 6;
                }
                y += 29;
                x = 46;
            }
        }
    }

    public boolean supportsRecipeTree() {
        return this.isSimple;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }

    public record BlockLootRecipeData(ResourceLocation id, List<WidgetRowBuilder> rowBuilderList, boolean guaranteed, InitializedSupplier<EmiStack> inputStack, InitializedSupplier<List<EmiStack>> outputStacks) {
        public static BlockLootRecipeData of(ClientBlockLootTable loot) {
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            boolean allStacksGuaranteed = true;
            ArrayList<WidgetRowBuilder> rowBuilderList = new ArrayList<WidgetRowBuilder>();
            ResourceLocation blockId = loot.blockId;
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
            loot.build((Level)Minecraft.m_91087_().f_91073_, block);
            for (ClientBuiltPool builtPool : loot.builtItems) {
                for (ConditionalStack stack : builtPool.stacks()) {
                    if (stack.weight() < 100.0f) {
                        allStacksGuaranteed = false;
                    }
                    itemStackList.addAll(stack.getRawStacks());
                }
                if (loot.isSimple) {
                    BlockLootRecipeData.addSimpleWidgetBuilder(rowBuilderList, builtPool);
                    continue;
                }
                BlockLootRecipeData.addWidgetBuilders(rowBuilderList, builtPool, false);
            }
            ResourceLocation id = new ResourceLocation("emi_loot", "/" + EmiClientPlugin.BLOCK_CATEGORY.id.m_135815_() + "/" + loot.id.m_135827_() + "/" + loot.id.m_135815_());
            InitializedSupplier<List<EmiStack>> outputStacks = new InitializedSupplier<List<EmiStack>>(() -> {
                ArrayList<EmiStack> list = new ArrayList<EmiStack>();
                for (ItemStack stack : itemStackList) {
                    list.add(EmiStack.of((ItemStack)stack));
                }
                return list;
            });
            InitializedSupplier<EmiStack> inputStack = new InitializedSupplier<EmiStack>(() -> block.m_5456_() == Items.f_41852_ ? new BlockStateEmiStack(block.m_49966_(), blockId) : EmiStack.of((ItemLike)block));
            return new BlockLootRecipeData(id, rowBuilderList, allStacksGuaranteed || loot.isSimple, inputStack, outputStacks);
        }

        private static void addSimpleWidgetBuilder(List<WidgetRowBuilder> rowBuilderList, ClientBuiltPool newPool) {
            WidgetRowBuilder builder = new WidgetRowBuilder(115);
            builder.addSimple(newPool);
            rowBuilderList.add(builder);
        }

        private static void addWidgetBuilders(List<WidgetRowBuilder> rowBuilderList, ClientBuiltPool newPool, boolean recursive) {
            WidgetRowBuilder builder;
            boolean newBuilder = false;
            if (recursive || rowBuilderList.isEmpty()) {
                builder = new WidgetRowBuilder(115);
                newBuilder = true;
            } else {
                builder = rowBuilderList.get(rowBuilderList.size() - 1);
            }
            Optional<ClientBuiltPool> opt = builder.addAndTrim(newPool);
            if (newBuilder) {
                rowBuilderList.add(builder);
            }
            opt.ifPresent(clientMobBuiltPool -> BlockLootRecipeData.addWidgetBuilders(rowBuilderList, clientMobBuiltPool, true));
        }
    }
}

