/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.StatePredicateAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StatePredicateParser {
    public static Component parseStatePredicate(StatePropertiesPredicate predicate) {
        List<StatePropertiesPredicate.PropertyMatcher> list = ((StatePredicateAccessor)predicate).getConditions();
        if (!list.isEmpty()) {
            LinkedList<MutableComponent> list2 = new LinkedList<MutableComponent>();
            for (StatePropertiesPredicate.PropertyMatcher condition : list) {
                String key;
                if (condition instanceof StatePropertiesPredicate.RangedPropertyMatcher) {
                    key = condition.f_67715_;
                    String min = ((StatePropertiesPredicate.RangedPropertyMatcher)condition).f_67727_;
                    String max = ((StatePropertiesPredicate.RangedPropertyMatcher)condition).f_67728_;
                    list2.add(LText.translatable("emi_loot.state_predicate.state_between", key, min, max));
                    continue;
                }
                if (!(condition instanceof StatePropertiesPredicate.ExactPropertyMatcher)) continue;
                key = condition.f_67715_;
                String value = ((StatePropertiesPredicate.ExactPropertyMatcher)condition).f_67707_;
                list2.add(LText.translatable("emi_loot.state_predicate.state_exact", key, value));
            }
            return LText.translatable("emi_loot.state_predicate.base", ListProcessors.buildAndList(list2));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable block/fluid state predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

