/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.tooltips.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.samsthenerd.inline.tooltips.data.EntityDisplayTTData;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntityDisplayTTComp
implements ClientTooltipComponent {
    public static final float DEFAULT_RENDER_SIZE = 96.0f;
    private EntityCradle cradle;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public EntityDisplayTTComp(EntityDisplayTTData tt) {
        this.cradle = tt.cradle;
        this.widthProvider = tt.widthProvider;
    }

    public void m_183452_(Font font, int mouseX, int mouseY, GuiGraphics context) {
        Entity ent = this.cradle.getEntity((Level)Minecraft.m_91087_().f_91073_);
        if (ent == null) {
            return;
        }
        AABB bounds = ent.m_20191_().m_82377_(0.0, 0.05, 0.0);
        double height = bounds.m_82376_();
        float rot = 15.0f;
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(ent);
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        int rHeight = this.getRenderHeight();
        int ttWidth = this.m_142069_(font);
        matrices.m_85837_((double)mouseX + (double)ttWidth / 2.0, (double)mouseY, 500.0);
        float scaleFactor = (float)((double)rHeight / height);
        matrices.m_85841_(scaleFactor, -scaleFactor, scaleFactor);
        matrices.m_85837_(0.0, -height, 0.0);
        Minecraft client = Minecraft.m_91087_();
        float tickDelta = client.m_91296_();
        matrices.m_252781_(Axis.f_252436_.m_252977_(rot));
        renderer.m_7392_(ent, 0.0f, 0.0f, matrices, (MultiBufferSource)context.m_280091_(), 0xF000F0);
        matrices.m_85849_();
    }

    public int m_142069_(Font pFont) {
        Entity ent = this.cradle.getEntity((Level)Minecraft.m_91087_().f_91073_);
        if (ent == null) {
            return 0;
        }
        AABB bounds = ent.m_20191_().m_82377_(0.0, 0.05, 0.0);
        double width = bounds.m_82362_();
        double depth = bounds.m_82385_();
        double height = bounds.m_82376_();
        float rot = 15.0f;
        double radRot = Math.toRadians(rot % 90.0f);
        double pWidth = width * Math.cos(radRot) + depth * Math.sin(radRot);
        return this.widthProvider.apply((int)(pWidth * 100.0), (int)(height * 100.0)) + 16;
    }

    private int getRenderHeight() {
        Entity ent = this.cradle.getEntity((Level)Minecraft.m_91087_().f_91073_);
        if (ent == null) {
            return 0;
        }
        AABB bounds = ent.m_20191_().m_82377_(0.0, 0.05, 0.0);
        double width = bounds.m_82362_();
        double depth = bounds.m_82385_();
        double height = bounds.m_82376_();
        float rot = 15.0f;
        double radRot = Math.toRadians(rot % 90.0f);
        double pWidth = width * Math.cos(radRot) + depth * Math.sin(radRot);
        int realWidth = this.widthProvider.apply((int)(pWidth * 100.0), (int)(height * 100.0));
        if (pWidth == 0.0) {
            return 0;
        }
        return (int)((double)realWidth * (height / pWidth));
    }

    public int m_142103_() {
        return this.getRenderHeight() + 4;
    }
}

