/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.event;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.block.SandwichBlockEntity;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public class BlockEventHandler {
    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(BlockEventHandler::onRightClickBlock);
    }

    private static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled() || event.getUseBlock() != Event.Result.DEFAULT || event.getUseItem() != Event.Result.DEFAULT) {
            return;
        }
        BlockPos pos = event.getHitVec().m_82425_();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos);
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (player.m_6144_()) {
            return;
        }
        if (state.m_204336_(ModTags.SANDWICHING_STATIONS)) {
            InteractionResult result;
            BlockEntity blockEntity = level.m_7702_(pos.m_7494_());
            if (blockEntity instanceof SandwichBlockEntity) {
                SandwichBlockEntity blockEntity2 = (SandwichBlockEntity)blockEntity;
                v0 = blockEntity2.interact(player, hand);
            } else {
                v0 = result = BlockEventHandler.tryPlaceSandwich(event);
            }
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        }
    }

    private static InteractionResult tryPlaceSandwich(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldItem = event.getItemStack().m_41777_();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        BlockHitResult hitResult = event.getHitVec();
        BlockPos pos = hitResult.m_82425_();
        heldItem.m_41764_(1);
        if (!Ingredients.canAddToSandwich(heldItem)) {
            return InteractionResult.PASS;
        }
        if (!heldItem.m_150930_((Item)ModItems.SANDWICH.get()) && !heldItem.m_204117_(ModTags.SANDWICH_BREAD)) {
            player.m_5661_((Component)SomeAssemblyRequired.translate("message.bottom_bread", new Object[0]), true);
            return InteractionResult.SUCCESS;
        }
        ItemStack sandwich = SandwichItem.of(heldItem);
        UseOnContext useOnContext = new UseOnContext(player, hand, hitResult);
        InteractionResult placeResult = ((SandwichItem)((Object)ModItems.SANDWICH.get())).place(useOnContext, pos.m_7494_(), sandwich);
        if (sandwich.m_41619_()) {
            player.m_21120_(hand).m_41774_(1);
        }
        return placeResult;
    }
}

