/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.registry.ModSoundEvents;
import someassemblyrequired.util.JsonHelper;

public class IngredientProperties {
    @Nullable
    private final FoodProperties foodProperties;
    @Nullable
    private final Component displayName;
    @Nullable
    private final Component fullName;
    private final ItemStack displayItem;
    private final ItemStack container;
    @Nullable
    private final SoundEvent soundEvent;
    private final int height;
    private final boolean renderAsItem;

    public IngredientProperties(FoodProperties foodProperties, Component displayName, Component fullName, ItemStack displayItem, ItemStack container, SoundEvent soundEvent, int height, boolean renderAsItem) {
        this.foodProperties = foodProperties;
        this.displayName = displayName;
        this.fullName = fullName;
        this.displayItem = displayItem;
        this.container = container;
        this.soundEvent = soundEvent;
        this.height = height;
        this.renderAsItem = renderAsItem;
    }

    public IngredientProperties() {
        this(null, null, null, ItemStack.f_41583_, ItemStack.f_41583_, null, 1, true);
    }

    @Nullable
    public FoodProperties getFood(ItemStack item, @Nullable LivingEntity entity) {
        if (this.foodProperties == null) {
            return item.m_41720_().getFoodProperties(item, entity);
        }
        return this.foodProperties;
    }

    public Component getDisplayName(ItemStack item) {
        if (this.displayName == null) {
            return this.getFullName(item);
        }
        return this.displayName;
    }

    public Component getFullName(ItemStack item) {
        if (this.fullName == null) {
            return item.m_41786_();
        }
        return this.fullName;
    }

    public ItemStack getDisplayItem(ItemStack item) {
        if (this.displayItem.m_41619_()) {
            return item;
        }
        return this.displayItem;
    }

    public ItemStack getContainer(ItemStack item) {
        if (this.container.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return this.container;
    }

    public boolean shouldRenderAsItem(ItemStack item) {
        return this.renderAsItem;
    }

    public int getHeight(ItemStack item) {
        return this.height;
    }

    public void playSound(Level level, Player player, BlockPos pos, float pitch) {
        SoundEvent soundEvent = this.soundEvent;
        if (soundEvent == null) {
            soundEvent = (SoundEvent)ModSoundEvents.ADD_ITEM.get();
        }
        level.m_5594_(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, pitch);
    }

    public JsonObject toJson(Item item) {
        JsonObject result = new JsonObject();
        String modid = ForgeRegistries.ITEMS.getKey((Object)item).m_135827_();
        if (!modid.equals("minecraft") && !modid.equals("some_assembly_required")) {
            JsonHelper.addModLoadedCondition(result, modid);
        }
        result.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)item).toString());
        if (this.foodProperties != null) {
            result.add("food", IngredientProperties.writeFoodProperties(this.foodProperties));
        }
        if (this.displayName != null) {
            result.add("displayName", Component.Serializer.m_130716_((Component)this.displayName));
        }
        if (this.fullName != null) {
            result.add("fullName", Component.Serializer.m_130716_((Component)this.fullName));
        }
        if (!this.displayItem.m_41619_()) {
            result.add("displayItem", (JsonElement)JsonHelper.writeItemStack(this.displayItem));
        }
        if (!this.container.m_41619_()) {
            result.add("container", (JsonElement)JsonHelper.writeItemStack(this.container));
        }
        if (this.soundEvent != null) {
            result.addProperty("soundEvent", ForgeRegistries.SOUND_EVENTS.getKey((Object)this.soundEvent).toString());
        }
        if (this.height != 1) {
            result.addProperty("height", (Number)this.height);
        }
        if (!this.renderAsItem) {
            result.addProperty("renderAsItem", Boolean.valueOf(false));
        }
        return result;
    }

    public static IngredientProperties fromJson(JsonObject object) {
        FoodProperties foodProperties = IngredientProperties.readFoodProperties(object, "food");
        MutableComponent displayName = null;
        if (object.has("displayName")) {
            displayName = Component.Serializer.m_130691_((JsonElement)object.get("displayName"));
        }
        MutableComponent fullName = null;
        if (object.has("fullName")) {
            fullName = Component.Serializer.m_130691_((JsonElement)object.get("fullName"));
        }
        ItemStack displayItem = IngredientProperties.readOptionalItemStack(object, "displayItem");
        ItemStack container = IngredientProperties.readOptionalItemStack(object, "container");
        SoundEvent soundEvent = null;
        if (object.has("soundEvent")) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"soundEvent"));
            if (!ForgeRegistries.SOUND_EVENTS.containsKey(id)) {
                throw new JsonParseException("No such sound event: " + id);
            }
            soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(id);
        }
        int height = 1;
        if (object.has("height") && (height = GsonHelper.m_13897_((JsonElement)object.get("height"), (String)"height")) < 1) {
            throw new JsonParseException("Ingredient height cannot be smaller than 1");
        }
        boolean renderAsItem = true;
        if (object.has("renderAsItem")) {
            renderAsItem = GsonHelper.m_13877_((JsonElement)object.get("renderAsItem"), (String)"renderAsItem");
        }
        return new IngredientProperties(foodProperties, (Component)displayName, (Component)fullName, displayItem, container, soundEvent, height, renderAsItem);
    }

    private static JsonElement writeFoodProperties(FoodProperties properties) {
        JsonObject result = new JsonObject();
        result.addProperty("nutrition", (Number)properties.m_38744_());
        result.addProperty("saturationModifier", (Number)Float.valueOf(properties.m_38745_()));
        return result;
    }

    @Nullable
    private static FoodProperties readFoodProperties(JsonObject object, String memberName) {
        if (!object.has(memberName)) {
            return null;
        }
        JsonObject foodObject = GsonHelper.m_13930_((JsonObject)object, (String)memberName);
        FoodProperties.Builder builder = new FoodProperties.Builder();
        return builder.m_38760_(GsonHelper.m_13927_((JsonObject)foodObject, (String)"nutrition")).m_38758_((float)GsonHelper.m_13927_((JsonObject)foodObject, (String)"saturationModifier")).m_38767_();
    }

    private static ItemStack readOptionalItemStack(JsonObject object, String memberName) {
        if (!object.has(memberName)) {
            return ItemStack.f_41583_;
        }
        return CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)object, (String)memberName), (boolean)true);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.foodProperties != null);
        if (this.foodProperties != null) {
            IngredientProperties.writeFoodProperties(buffer, this.foodProperties);
        }
        buffer.writeBoolean(this.displayName != null);
        if (this.displayName != null) {
            buffer.m_130083_(this.displayName);
        }
        buffer.writeBoolean(this.fullName != null);
        if (this.fullName != null) {
            buffer.m_130083_(this.fullName);
        }
        buffer.m_130055_(this.displayItem);
        buffer.m_130055_(this.container);
        buffer.writeBoolean(this.soundEvent != null);
        if (this.soundEvent != null) {
            buffer.m_130085_(ForgeRegistries.SOUND_EVENTS.getKey((Object)this.soundEvent));
        }
        buffer.writeInt(this.height);
        buffer.writeBoolean(this.renderAsItem);
    }

    public static IngredientProperties fromNetwork(FriendlyByteBuf buffer) {
        FoodProperties foodProperties = null;
        if (buffer.readBoolean()) {
            foodProperties = IngredientProperties.readFoodProperties(buffer);
        }
        Component displayName = null;
        if (buffer.readBoolean()) {
            displayName = buffer.m_130238_();
        }
        Component fullName = null;
        if (buffer.readBoolean()) {
            fullName = buffer.m_130238_();
        }
        ItemStack displayItem = buffer.m_130267_();
        ItemStack container = buffer.m_130267_();
        SoundEvent soundEvent = null;
        if (buffer.readBoolean()) {
            soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.m_130281_());
        }
        int height = buffer.readInt();
        boolean renderAsItem = buffer.readBoolean();
        return new IngredientProperties(foodProperties, displayName, fullName, displayItem, container, soundEvent, height, renderAsItem);
    }

    private static void writeFoodProperties(FriendlyByteBuf buffer, FoodProperties foodProperties) {
        buffer.writeInt(foodProperties.m_38744_());
        buffer.writeFloat(foodProperties.m_38745_());
    }

    private static FoodProperties readFoodProperties(FriendlyByteBuf buffer) {
        return new FoodProperties.Builder().m_38760_(buffer.readInt()).m_38758_(buffer.readFloat()).m_38767_();
    }
}

