/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.registry;

import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.item.EnchantedGoldenAppleSlicesItem;
import someassemblyrequired.item.SpreadItem;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.registry.ModBlocks;
import someassemblyrequired.registry.ModFoods;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"some_assembly_required");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"some_assembly_required");
    public static RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_MODE_TABS.register("main", () -> CreativeModeTab.builder().m_257737_(ModItems::makeIcon).m_257941_((Component)Component.m_237115_((String)"%s.creative_tab".formatted("some_assembly_required"))).m_257501_(ModItems::fillCreativeTab).m_257652_());
    public static final RegistryObject<Item> SANDWICHING_STATION = ITEMS.register("sandwiching_station", () -> ModItems.createBlockItem((Block)ModBlocks.SANDWICHING_STATION.get()));
    public static final RegistryObject<Item> BREAD_SLICE = ITEMS.register("bread_slice", () -> ModItems.createFoodItem(ModFoods.BREAD_SLICE));
    public static final RegistryObject<Item> TOASTED_BREAD_SLICE = ITEMS.register("toasted_bread_slice", () -> ModItems.createFoodItem(ModFoods.TOASTED_BREAD_SLICE));
    public static final RegistryObject<Item> BURGER_BUN = ITEMS.register("burger_bun", () -> ModItems.createFoodItem(ModFoods.BURGER_BUN));
    public static final RegistryObject<Item> BURGER_BUN_BOTTOM = ITEMS.register("burger_bun_bottom", () -> ModItems.createFoodItem(ModFoods.BURGER_BUN_BOTTOM));
    public static final RegistryObject<Item> BURGER_BUN_TOP = ITEMS.register("burger_bun_top", () -> ModItems.createFoodItem(ModFoods.BURGER_BUN_TOP));
    public static final RegistryObject<Item> APPLE_SLICES = ITEMS.register("apple_slices", () -> ModItems.createFoodItem(ModFoods.APPLE_SLICES));
    public static final RegistryObject<Item> GOLDEN_APPLE_SLICES = ITEMS.register("golden_apple_slices", () -> new Item(new Item.Properties().m_41489_(ModFoods.GOLDEN_APPLE_SLICES).m_41497_(Rarity.RARE)));
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_APPLE_SLICES = ITEMS.register("enchanted_golden_apple_slices", () -> new EnchantedGoldenAppleSlicesItem(new Item.Properties().m_41489_(ModFoods.ENCHANTED_GOLDEN_APPLE_SLICES).m_41497_(Rarity.EPIC)));
    public static final RegistryObject<Item> CHOPPED_CARROT = ITEMS.register("chopped_carrot", () -> ModItems.createFoodItem(ModFoods.CHOPPED_CARROT));
    public static final RegistryObject<Item> CHOPPED_GOLDEN_CARROT = ITEMS.register("chopped_golden_carrot", () -> ModItems.createFoodItem(ModFoods.CHOPPED_GOLDEN_CARROT));
    public static final RegistryObject<Item> CHOPPED_BEETROOT = ITEMS.register("chopped_beetroot", () -> ModItems.createFoodItem(ModFoods.CHOPPED_BEETROOT));
    public static final RegistryObject<Item> TOMATO_SLICES = ITEMS.register("tomato_slices", () -> ModItems.createFoodItem(ModFoods.TOMATO_SLICES));
    public static final RegistryObject<Item> SLICED_ONION = ITEMS.register("sliced_onion", () -> ModItems.createFoodItem(ModFoods.SLICED_ONION));
    public static final RegistryObject<SandwichItem> SANDWICH = ITEMS.register("sandwich", () -> new SandwichItem((Block)ModBlocks.SANDWICH.get(), new Item.Properties().m_41487_(16).m_41489_(ModFoods.EMPTY)));
    public static final RegistryObject<Item> SPREAD = ITEMS.register("spread", () -> new SpreadItem(new Item.Properties()));

    private static ItemStack makeIcon() {
        return new ItemStack((ItemLike)BREAD_SLICE.get());
    }

    private static void fillCreativeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> {
            String namespace = ForgeRegistries.ITEMS.getKey(item).m_135827_();
            return namespace.equals("some_assembly_required");
        }).filter(item -> item != SPREAD.get()).filter(item -> item != SANDWICH.get()).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        ModCompat.gatherCreativeTabSandwiches(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
    }

    private static Item createBlockItem(Block block) {
        return new BlockItem(block, new Item.Properties());
    }

    private static Item createFoodItem(FoodProperties food) {
        return new Item(new Item.Properties().m_41489_(food));
    }

    public static void registerCompostables() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)BREAD_SLICE.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)TOASTED_BREAD_SLICE.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)BURGER_BUN.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)BURGER_BUN_BOTTOM.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)BURGER_BUN_TOP.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)APPLE_SLICES.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)CHOPPED_CARROT.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)CHOPPED_BEETROOT.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)TOMATO_SLICES.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)SLICED_ONION.get()), 0.3f);
    }
}

