/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blockentities;

import com.blackgear.vanillabackport.client.level.particles.particleoptions.TrailParticleOption;
import com.blackgear.vanillabackport.client.registries.ModParticles;
import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.level.blocks.blockstates.CreakingHeartState;
import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import com.blackgear.vanillabackport.common.registries.ModBlockEntities;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.blackgear.vanillabackport.core.util.SpawnExtras;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class CreakingHeartBlockEntity
extends BlockEntity {
    private static final Optional<Creaking> NO_CREAKING = Optional.empty();
    @Nullable
    private Either<Creaking, UUID> creakingInfo;
    private long ticksExisted;
    private int ticker;
    private int emitter;
    @Nullable
    private Vec3 emitterTarget;
    private int outputSignal;

    public CreakingHeartBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CREAKING_HEART.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CreakingHeartBlockEntity heart) {
        ++heart.ticksExisted;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int signal = heart.computeAnalogOutputSignal();
            if (heart.outputSignal != signal) {
                heart.outputSignal = signal;
                level.m_46717_(pos, ModBlocks.CREAKING_HEART.get());
            }
            if (heart.emitter > 0) {
                if (heart.emitter > 50) {
                    heart.emitParticles(server, 1, true);
                    heart.emitParticles(server, 1, false);
                }
                if (heart.emitter % 10 == 0 && heart.emitterTarget != null) {
                    heart.getCreakingProtector().ifPresent(creaking -> {
                        heart.emitterTarget = creaking.m_20191_().m_82399_();
                    });
                    Vec3 center = Vec3.m_82512_((Vec3i)pos);
                    float emission = 0.2f + 0.8f * (float)(100 - heart.emitter) / 100.0f;
                    Vec3 position = center.m_82546_(heart.emitterTarget).m_82490_((double)emission).m_82549_(heart.emitterTarget);
                    BlockPos target = BlockPos.m_274446_((Position)position);
                    float volume = (float)heart.emitter / 2.0f / 100.0f + 0.5f;
                    level.m_5594_(null, target, ModSoundEvents.CREAKING_HEART_HURT.get(), SoundSource.BLOCKS, volume, 1.0f);
                }
                --heart.emitter;
            }
            if (heart.ticker-- < 0) {
                heart.ticker = heart.f_58857_ == null ? 20 : heart.f_58857_.f_46441_.m_188503_(5) + 20;
                BlockState updatedState = CreakingHeartBlockEntity.updateCreakingState(level, state, pos, heart);
                if (updatedState != state) {
                    level.m_7731_(pos, updatedState, 3);
                    if (updatedState.m_61143_(CreakingHeartBlock.STATE) == CreakingHeartState.UPROOTED) {
                        return;
                    }
                }
                if (heart.creakingInfo == null) {
                    Player player;
                    if (updatedState.m_61143_(CreakingHeartBlock.STATE) == CreakingHeartState.AWAKE && level.m_46791_() != Difficulty.PEACEFUL && level.m_46469_().m_46207_(GameRules.f_46134_) && (player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 32.0, false)) != null && (creaking = CreakingHeartBlockEntity.spawnProtector(server, heart)) != null) {
                        heart.setCreakingInfo(creaking);
                        creaking.m_216990_(ModSoundEvents.CREAKING_SPAWN.get());
                        level.m_5594_(null, heart.m_58899_(), ModSoundEvents.CREAKING_HEART_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    Optional<Creaking> protector = heart.getCreakingProtector();
                    if (protector.isPresent()) {
                        creaking = protector.get();
                        if (!CreakingHeartBlock.isNaturalNight(level) && !creaking.m_21532_() || heart.distanceToCreaking() > 34.0 || creaking.playerIsStuckInYou()) {
                            heart.removeProtector(null);
                        }
                    }
                }
            }
        }
    }

    private static BlockState updateCreakingState(Level level, BlockState state, BlockPos pos, CreakingHeartBlockEntity heart) {
        if (!CreakingHeartBlock.hasRequiredLogs(state, (LevelReader)level, pos) && heart.creakingInfo == null) {
            return (BlockState)state.m_61124_(CreakingHeartBlock.STATE, (Comparable)((Object)CreakingHeartState.UPROOTED));
        }
        boolean isNaturalNight = CreakingHeartBlock.isNaturalNight(level);
        return (BlockState)state.m_61124_(CreakingHeartBlock.STATE, (Comparable)((Object)(isNaturalNight ? CreakingHeartState.AWAKE : CreakingHeartState.DORMANT)));
    }

    private double distanceToCreaking() {
        return this.getCreakingProtector().map(creaking -> Math.sqrt(creaking.m_20238_(Vec3.m_82539_((Vec3i)this.m_58899_())))).orElse(0.0);
    }

    private void clearCreakingInfo() {
        this.creakingInfo = null;
        this.m_6596_();
    }

    public void setCreakingInfo(Creaking creaking) {
        this.creakingInfo = Either.left((Object)((Object)creaking));
        this.m_6596_();
    }

    public void setCreakingInfo(UUID uuid) {
        this.creakingInfo = Either.right((Object)uuid);
        this.ticksExisted = 0L;
        this.m_6596_();
    }

    private Optional<Creaking> getCreakingProtector() {
        Level level;
        if (this.creakingInfo == null) {
            return NO_CREAKING;
        }
        if (this.creakingInfo.left().isPresent()) {
            Creaking creaking = (Creaking)((Object)this.creakingInfo.left().get());
            if (!creaking.m_213877_()) {
                return Optional.of(creaking);
            }
            this.setCreakingInfo(creaking.m_20148_());
        }
        if ((level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.creakingInfo.right().isPresent()) {
                UUID uuid = (UUID)this.creakingInfo.right().get();
                Entity entity = server.m_8791_(uuid);
                if (entity instanceof Creaking) {
                    Creaking creaking = (Creaking)entity;
                    this.setCreakingInfo(creaking);
                    return Optional.of(creaking);
                }
                if (this.ticksExisted >= 30L) {
                    this.clearCreakingInfo();
                }
                return NO_CREAKING;
            }
        }
        return NO_CREAKING;
    }

    @Nullable
    private static Creaking spawnProtector(ServerLevel level, CreakingHeartBlockEntity heart) {
        if (!((Boolean)VanillaBackport.COMMON_CONFIG.hasCreaking.get()).booleanValue()) {
            return null;
        }
        BlockPos pos = heart.m_58899_();
        Optional<Creaking> protector = SpawnExtras.trySpawnMob(ModEntities.CREAKING.get(), MobSpawnType.SPAWNER, level, pos, 5, 16, 8, SpawnExtras.ON_TOP_OF_COLLIDER_NO_LEAVES, true);
        if (protector.isEmpty()) {
            return null;
        }
        Creaking creaking = protector.get();
        level.m_220400_((Entity)creaking, GameEvent.f_157810_, creaking.m_20182_());
        level.m_7605_((Entity)creaking, (byte)60);
        creaking.setTransient(pos);
        return creaking;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void creakingHurt() {
        Level level;
        Creaking creaking = this.getCreakingProtector().orElse(null);
        if (creaking != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.emitter <= 0) {
                this.emitParticles(server, 20, false);
                if (this.m_58900_().m_61143_(CreakingHeartBlock.STATE) == CreakingHeartState.AWAKE && ((Boolean)VanillaBackport.COMMON_CONFIG.hasResin.get()).booleanValue()) {
                    int i = this.f_58857_.m_213780_().m_216332_(2, 3);
                    for (int j = 0; j < i; ++j) {
                        this.spreadResin().ifPresent(pos -> {
                            this.f_58857_.m_5594_(null, pos, ModSoundEvents.RESIN_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            this.f_58857_.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
                        });
                    }
                }
                this.emitter = 100;
                this.emitterTarget = creaking.m_20191_().m_82399_();
            }
        }
    }

    private Optional<BlockPos> spreadResin() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        MutableObject mutable = new MutableObject(null);
        BlockPos.m_276833_((BlockPos)this.f_58858_, (int)2, (int)64, (pos, consumer) -> {
            for (Direction direction : Util.m_214681_((Object[])Direction.values(), (RandomSource)this.f_58857_.m_213780_())) {
                BlockPos neighbor = pos.m_121945_(direction);
                if (!this.f_58857_.m_8055_(neighbor).m_204336_(ModBlockTags.PALE_OAK_LOGS)) continue;
                consumer.accept(neighbor);
            }
        }, arg_0 -> this.lambda$spreadResin$4((Mutable)mutable, arg_0));
        return Optional.ofNullable((BlockPos)mutable.getValue());
    }

    private void emitParticles(ServerLevel level, int count, boolean reverseDirection) {
        Creaking creaking = this.getCreakingProtector().orElse(null);
        if (creaking != null) {
            int color = reverseDirection ? (Integer)VanillaBackport.COMMON_CONFIG.creakingParticleReverseColor.get() : (Integer)VanillaBackport.COMMON_CONFIG.creakingParticleColor.get();
            RandomSource random = level.m_213780_();
            for (double i = 0.0; i < (double)count; i += 1.0) {
                AABB creakingBounds = creaking.m_20191_();
                Vec3 currentPos = new Vec3(creakingBounds.f_82288_, creakingBounds.f_82289_, creakingBounds.f_82290_).m_82520_(random.m_188500_() * creakingBounds.m_82362_(), random.m_188500_() * creakingBounds.m_82376_(), random.m_188500_() * creakingBounds.m_82385_());
                Vec3 heartPos = Vec3.m_82528_((Vec3i)this.m_58899_()).m_82520_(random.m_188500_(), random.m_188500_(), random.m_188500_());
                if (reverseDirection) {
                    Vec3 target = currentPos;
                    currentPos = heartPos;
                    heartPos = target;
                }
                TrailParticleOption particle = new TrailParticleOption(heartPos, color, random.m_188503_(40) + 10);
                ModParticles.sendParticles(level, particle, true, true, currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void removeProtector(@Nullable DamageSource source) {
        Creaking creaking = this.getCreakingProtector().orElse(null);
        if (creaking != null) {
            if (source == null) {
                creaking.tearDown();
            } else {
                creaking.creakingDeathEffects(source);
                creaking.setTearingDown();
                creaking.m_21153_(0.0f);
            }
            this.clearCreakingInfo();
        }
    }

    public boolean isProtector(Creaking creaking) {
        return this.getCreakingProtector().map(target -> target == creaking).orElse(false);
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    public int computeAnalogOutputSignal() {
        if (this.creakingInfo != null && this.getCreakingProtector().isPresent()) {
            double distance = this.distanceToCreaking();
            double signalFromDistance = Mth.m_14008_((double)distance, (double)0.0, (double)32.0) / 32.0;
            return 15 - (int)Math.floor(signalFromDistance * 15.0);
        }
        return 0;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128403_("creaking")) {
            this.setCreakingInfo(tag.m_128342_("creaking"));
        } else {
            this.clearCreakingInfo();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.creakingInfo != null) {
            tag.m_128362_("creaking", (UUID)this.creakingInfo.map(Entity::m_20148_, uuid -> uuid));
        }
    }

    private /* synthetic */ boolean lambda$spreadResin$4(Mutable mutable, BlockPos pos) {
        if (this.f_58857_.m_8055_(pos).m_204336_(ModBlockTags.PALE_OAK_LOGS)) {
            for (Direction direction : Util.m_214681_((Object[])Direction.values(), (RandomSource)this.f_58857_.m_213780_())) {
                BlockPos neighbor = pos.m_121945_(direction);
                BlockState neighborState = this.f_58857_.m_8055_(neighbor);
                Direction opposite = direction.m_122424_();
                Block resinClump = ModBlocks.RESIN_CLUMP.get();
                if (neighborState.m_60795_()) {
                    neighborState = resinClump.m_49966_();
                } else if (neighborState.m_60713_(Blocks.f_49990_) && neighborState.m_60819_().m_76170_()) {
                    neighborState = (BlockState)resinClump.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
                if (!neighborState.m_60713_(resinClump) || MultifaceBlock.m_153900_((BlockState)neighborState, (Direction)opposite)) continue;
                this.f_58857_.m_7731_(neighbor, (BlockState)neighborState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)opposite), (Comparable)Boolean.valueOf(true)), 3);
                mutable.setValue((Object)neighbor);
                return false;
            }
        }
        return true;
    }
}

