/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster;

import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class MBCalculator<TBlockEntity extends IAEMultiBlock<TCluster>, TCluster extends IAECluster> {
    private static WeakReference<IAECluster> modificationInProgress = new WeakReference<Object>(null);
    protected final TBlockEntity target;

    public MBCalculator(TBlockEntity t) {
        this.target = t;
    }

    public static void setModificationInProgress(IAECluster cluster) {
        IAECluster inProgress = (IAECluster)modificationInProgress.get();
        if (inProgress == cluster) {
            return;
        }
        if (inProgress != null && cluster != null) {
            throw new IllegalStateException("A modification is already in-progress for: " + String.valueOf(inProgress));
        }
        modificationInProgress = new WeakReference<IAECluster>(cluster);
    }

    public static boolean isModificationInProgress() {
        return modificationInProgress.get() != null;
    }

    public void updateMultiblockAfterNeighborUpdate(ServerLevel level, BlockPos loc, BlockPos changedPos) {
        Object cluster = this.target.getCluster();
        boolean recheck = cluster != null ? (MBCalculator.isWithinBounds(changedPos, cluster.getBoundsMin(), cluster.getBoundsMax()) ? true : this.isValidBlockEntityAt((Level)level, changedPos.m_123341_(), changedPos.m_123342_(), changedPos.m_123343_())) : true;
        if (recheck) {
            this.calculateMultiblock(level, loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateMultiblock(ServerLevel level, BlockPos loc) {
        block18: {
            if (MBCalculator.isModificationInProgress()) {
                return;
            }
            Object currentCluster = this.target.getCluster();
            if (currentCluster != null && currentCluster.isDestroyed()) {
                return;
            }
            try {
                BlockPos.MutableBlockPos min = loc.m_122032_();
                BlockPos.MutableBlockPos max = loc.m_122032_();
                while (this.isValidBlockEntityAt((Level)level, min.m_123341_() - 1, min.m_123342_(), min.m_123343_())) {
                    min.m_142451_(min.m_123341_() - 1);
                }
                while (this.isValidBlockEntityAt((Level)level, min.m_123341_(), min.m_123342_() - 1, min.m_123343_())) {
                    min.m_142448_(min.m_123342_() - 1);
                }
                while (this.isValidBlockEntityAt((Level)level, min.m_123341_(), min.m_123342_(), min.m_123343_() - 1)) {
                    min.m_142443_(min.m_123343_() - 1);
                }
                while (this.isValidBlockEntityAt((Level)level, max.m_123341_() + 1, max.m_123342_(), max.m_123343_())) {
                    max.m_142451_(max.m_123341_() + 1);
                }
                while (this.isValidBlockEntityAt((Level)level, max.m_123341_(), max.m_123342_() + 1, max.m_123343_())) {
                    max.m_142448_(max.m_123342_() + 1);
                }
                while (this.isValidBlockEntityAt((Level)level, max.m_123341_(), max.m_123342_(), max.m_123343_() + 1)) {
                    max.m_142443_(max.m_123343_() + 1);
                }
                if (!this.checkMultiblockScale((BlockPos)min, (BlockPos)max) || !this.verifyUnownedRegion(level, (BlockPos)min, (BlockPos)max)) break block18;
                try {
                    if (!this.verifyInternalStructure(level, (BlockPos)min, (BlockPos)max)) {
                        this.disconnect();
                        return;
                    }
                }
                catch (Exception err) {
                    this.disconnect();
                    return;
                }
                boolean updateGrid = false;
                Object cluster = this.target.getCluster();
                if (cluster == null || !cluster.getBoundsMin().equals((Object)min) || !cluster.getBoundsMax().equals((Object)max)) {
                    cluster = this.createCluster(level, (BlockPos)min, (BlockPos)max);
                    MBCalculator.setModificationInProgress(cluster);
                    this.updateBlockEntities(cluster, level, (BlockPos)min, (BlockPos)max);
                    updateGrid = true;
                } else {
                    MBCalculator.setModificationInProgress(cluster);
                }
                cluster.updateStatus(updateGrid);
                return;
            }
            finally {
                MBCalculator.setModificationInProgress(null);
            }
        }
        this.disconnect();
    }

    private static boolean isWithinBounds(BlockPos pos, BlockPos boundsMin, BlockPos boundsMax) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        return x >= boundsMin.m_123341_() && y >= boundsMin.m_123342_() && z >= boundsMin.m_123343_() && x <= boundsMax.m_123341_() && y <= boundsMax.m_123342_() && z <= boundsMax.m_123343_();
    }

    private boolean isValidBlockEntityAt(Level level, int x, int y, int z) {
        return this.isValidBlockEntity(level.m_7702_(new BlockPos(x, y, z)));
    }

    public abstract boolean checkMultiblockScale(BlockPos var1, BlockPos var2);

    private boolean verifyUnownedRegion(ServerLevel level, BlockPos min, BlockPos max) {
        for (Direction side : Direction.values()) {
            if (!this.verifyUnownedRegionInner(level, min.m_123341_(), min.m_123342_(), min.m_123343_(), max.m_123341_(), max.m_123342_(), max.m_123343_(), side)) continue;
            return false;
        }
        return true;
    }

    public abstract TCluster createCluster(ServerLevel var1, BlockPos var2, BlockPos var3);

    public abstract boolean verifyInternalStructure(ServerLevel var1, BlockPos var2, BlockPos var3);

    public void disconnect() {
        this.target.disconnect(true);
    }

    public abstract void updateBlockEntities(TCluster var1, ServerLevel var2, BlockPos var3, BlockPos var4);

    public abstract boolean isValidBlockEntity(BlockEntity var1);

    private boolean verifyUnownedRegionInner(ServerLevel level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Direction side) {
        switch (side) {
            case WEST: {
                maxX = --minX;
                break;
            }
            case EAST: {
                minX = ++maxX;
                break;
            }
            case DOWN: {
                maxY = --minY;
                break;
            }
            case NORTH: {
                minZ = ++maxZ;
                break;
            }
            case SOUTH: {
                maxZ = --minZ;
                break;
            }
            case UP: {
                minY = ++maxY;
                break;
            }
            default: {
                return false;
            }
        }
        for (BlockPos p : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockEntity te = level.m_7702_(p);
            if (!this.isValidBlockEntity(te)) continue;
            return true;
        }
        return false;
    }
}

