/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config.impl;

import com.google.gson.JsonObject;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigButton;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.common.config.impl.ConfigLoaderImpl;
import com.teamresourceful.resourcefulconfig.common.config.impl.ResourcefulConfigEntryImpl;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncObject;
import com.teamresourceful.resourcefulconfig.common.utils.ModUtils;
import com.teamresourceful.resourcefulconfig.web.info.ResourcefulWebConfig;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcefulConfigImpl
implements ResourcefulConfig {
    private final ResourcefulWebConfig web;
    private final Map<String, ResourcefulConfigEntryImpl> entries;
    private final List<ResourcefulConfigButton> buttons;
    private final Map<String, ResourcefulConfigImpl> configs;
    private final String fileName;
    private final String translation;

    public ResourcefulConfigImpl(ResourcefulWebConfig web, Map<String, ResourcefulConfigEntryImpl> entries, List<ResourcefulConfigButton> buttons, Map<String, ResourcefulConfigImpl> configs, String fileName, String translation) {
        this.web = web;
        this.entries = entries;
        this.buttons = buttons;
        this.configs = configs;
        this.fileName = fileName;
        this.translation = translation;
    }

    private File getConfigFile() {
        Path configDir = ModUtils.getConfigPath();
        File jsonFile = configDir.resolve(this.fileName + ".json").toFile();
        if (jsonFile.exists()) {
            return jsonFile;
        }
        return configDir.resolve(this.fileName + ".jsonc").toFile();
    }

    @Override
    public Map<String, ? extends ResourcefulConfigEntry> getEntries() {
        return this.entries;
    }

    @Override
    public List<? extends ResourcefulConfigButton> getButtons() {
        return this.buttons;
    }

    @Override
    public Map<String, ? extends ResourcefulConfig> getSubConfigs() {
        return this.configs;
    }

    @Override
    @NotNull
    public ResourcefulWebConfig getWebConfig() {
        return this.web;
    }

    @Override
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String translation() {
        return this.translation;
    }

    @Override
    public void save() {
        if (this.fileName != null) {
            try {
                JsoncObject json = new JsoncObject();
                ConfigLoaderImpl.saveConfig(this, json);
                FileUtils.write((File)this.getConfigFile(), (CharSequence)json.toString(), (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                System.out.println("Failed to save config file " + this.fileName + ".json");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void load() {
        File file = this.getConfigFile();
        if (file.exists()) {
            try {
                String data = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                JsonObject json = JsoncObject.parse(data);
                ConfigLoaderImpl.loadConfig(this, json);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file.getName().endsWith(".json") && !file.delete()) {
                System.out.println("Failed to delete old config file " + this.fileName + ".json");
            }
        }
    }
}

