/*
 * Decompiled with CFR 0.152.
 */
package com.example.SoundOfRain.materialsound;

import com.example.SoundOfRain.SoundOfRainConfig;
import com.example.SoundOfRain.materialsound.MaterialRainSoundHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class MaterialRainSoundRegister {
    private static final Map<Block, MaterialRainSoundHandler.MaterialSoundType> BLOCK_SOUND_MAP = new HashMap<Block, MaterialRainSoundHandler.MaterialSoundType>();
    private static final Map<TagKey<Block>, MaterialRainSoundHandler.MaterialSoundType> TAG_SOUND_MAP = new HashMap<TagKey<Block>, MaterialRainSoundHandler.MaterialSoundType>();
    private static final Set<String> BLACKLISTED_MODS = new HashSet<String>();
    private static final Set<TagKey<Block>> BLACKLISTED_TAGS = new HashSet<TagKey<Block>>();
    private static final Set<Block> BLACKLISTED_BLOCKS = new HashSet<Block>();
    private static final Set<String> BLACKLISTED_NAME_PATTERNS = new HashSet<String>();

    public static void loadMappingsFromConfig() {
        Block block;
        TagKey tag;
        ResourceLocation tagLoc;
        BLOCK_SOUND_MAP.clear();
        TAG_SOUND_MAP.clear();
        MaterialRainSoundRegister.loadBlacklistsFromConfig();
        for (String tagId : (List)SoundOfRainConfig.CLIENT.amethystTags.get()) {
            tagLoc = new ResourceLocation(tagId.replace("#", ""));
            tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagLoc);
            TAG_SOUND_MAP.put((TagKey<Block>)tag, MaterialRainSoundHandler.MaterialSoundType.AMETHYST);
        }
        for (String blockId : (List)SoundOfRainConfig.CLIENT.amethystBlocks.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) continue;
            BLOCK_SOUND_MAP.put(block, MaterialRainSoundHandler.MaterialSoundType.AMETHYST);
        }
        for (String tagId : (List)SoundOfRainConfig.CLIENT.fabricTags.get()) {
            tagLoc = new ResourceLocation(tagId.replace("#", ""));
            tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagLoc);
            TAG_SOUND_MAP.put((TagKey<Block>)tag, MaterialRainSoundHandler.MaterialSoundType.FABRIC);
        }
        for (String blockId : (List)SoundOfRainConfig.CLIENT.fabricBlocks.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) continue;
            BLOCK_SOUND_MAP.put(block, MaterialRainSoundHandler.MaterialSoundType.FABRIC);
        }
        for (String tagId : (List)SoundOfRainConfig.CLIENT.foliageTags.get()) {
            tagLoc = new ResourceLocation(tagId.replace("#", ""));
            tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagLoc);
            TAG_SOUND_MAP.put((TagKey<Block>)tag, MaterialRainSoundHandler.MaterialSoundType.FOLIAGE);
        }
        for (String blockId : (List)SoundOfRainConfig.CLIENT.foliageBlocks.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) continue;
            BLOCK_SOUND_MAP.put(block, MaterialRainSoundHandler.MaterialSoundType.FOLIAGE);
        }
        for (String tagId : (List)SoundOfRainConfig.CLIENT.glassTags.get()) {
            tagLoc = new ResourceLocation(tagId.replace("#", ""));
            tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagLoc);
            TAG_SOUND_MAP.put((TagKey<Block>)tag, MaterialRainSoundHandler.MaterialSoundType.GLASS);
        }
        for (String blockId : (List)SoundOfRainConfig.CLIENT.glassBlocks.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) continue;
            BLOCK_SOUND_MAP.put(block, MaterialRainSoundHandler.MaterialSoundType.GLASS);
        }
        for (String tagId : (List)SoundOfRainConfig.CLIENT.metalTags.get()) {
            tagLoc = new ResourceLocation(tagId.replace("#", ""));
            tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagLoc);
            TAG_SOUND_MAP.put((TagKey<Block>)tag, MaterialRainSoundHandler.MaterialSoundType.METAL);
        }
        for (String blockId : (List)SoundOfRainConfig.CLIENT.metalBlocks.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) continue;
            BLOCK_SOUND_MAP.put(block, MaterialRainSoundHandler.MaterialSoundType.METAL);
        }
        System.out.println("Loaded block mappings: " + BLOCK_SOUND_MAP);
        System.out.println("Loaded tag mappings: " + TAG_SOUND_MAP);
        for (String tagId : (List)SoundOfRainConfig.CLIENT.sandTags.get()) {
            tagLoc = new ResourceLocation(tagId.replace("#", ""));
            tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagLoc);
            TAG_SOUND_MAP.put((TagKey<Block>)tag, MaterialRainSoundHandler.MaterialSoundType.SAND);
        }
        for (String blockId : (List)SoundOfRainConfig.CLIENT.sandBlocks.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) continue;
            BLOCK_SOUND_MAP.put(block, MaterialRainSoundHandler.MaterialSoundType.SAND);
        }
        for (String tagId : (List)SoundOfRainConfig.CLIENT.woodTags.get()) {
            tagLoc = new ResourceLocation(tagId.replace("#", ""));
            tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagLoc);
            TAG_SOUND_MAP.put((TagKey<Block>)tag, MaterialRainSoundHandler.MaterialSoundType.WOOD);
        }
        for (String blockId : (List)SoundOfRainConfig.CLIENT.woodBlocks.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) continue;
            BLOCK_SOUND_MAP.put(block, MaterialRainSoundHandler.MaterialSoundType.WOOD);
        }
    }

    public static MaterialRainSoundHandler.MaterialSoundType getSoundType(Block block) {
        if (block.m_49966_().m_60795_()) {
            if (((Boolean)SoundOfRainConfig.CLIENT.debugShowSoundBlock.get()).booleanValue()) {
                // empty if block
            }
            return null;
        }
        if (MaterialRainSoundRegister.isBlockBlacklisted(block)) {
            return null;
        }
        MaterialRainSoundHandler.MaterialSoundType type = BLOCK_SOUND_MAP.get(block);
        if (((Boolean)SoundOfRainConfig.CLIENT.debugShowSoundBlock.get()).booleanValue()) {
            // empty if block
        }
        if (type != null) {
            return type;
        }
        for (Map.Entry<TagKey<Block>, MaterialRainSoundHandler.MaterialSoundType> entry : TAG_SOUND_MAP.entrySet()) {
            if (!block.m_49966_().m_204336_(entry.getKey())) continue;
            if (((Boolean)SoundOfRainConfig.CLIENT.debugShowSoundBlock.get()).booleanValue()) {
                // empty if block
            }
            return entry.getValue();
        }
        return null;
    }

    public static boolean isBlockBlacklisted(Block block) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockId == null) {
            return false;
        }
        String blockNamespace = blockId.m_135827_();
        String blockPath = blockId.m_135815_();
        if (BLACKLISTED_MODS.contains(blockNamespace)) {
            return true;
        }
        if (BLACKLISTED_BLOCKS.contains(block)) {
            return true;
        }
        for (String string : BLACKLISTED_NAME_PATTERNS) {
            if (!blockPath.toLowerCase().contains(string.toLowerCase())) continue;
            return true;
        }
        for (TagKey tagKey : BLACKLISTED_TAGS) {
            if (!block.m_49966_().m_204336_(tagKey)) continue;
            return true;
        }
        return false;
    }

    public static void loadBlacklistsFromConfig() {
        BLACKLISTED_MODS.clear();
        BLACKLISTED_TAGS.clear();
        BLACKLISTED_BLOCKS.clear();
        BLACKLISTED_NAME_PATTERNS.clear();
        for (String mod : (List)SoundOfRainConfig.CLIENT.blacklistedMods.get()) {
            if (mod.isEmpty() || mod.isBlank()) continue;
            BLACKLISTED_MODS.add(mod.toLowerCase());
        }
        for (String tagId : (List)SoundOfRainConfig.CLIENT.blacklistedTags.get()) {
            if (tagId.isEmpty() || tagId.isBlank()) continue;
            ResourceLocation tagLoc = new ResourceLocation(tagId.replace("#", ""));
            TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagLoc);
            BLACKLISTED_TAGS.add((TagKey<Block>)tag);
        }
        for (String blockId : (List)SoundOfRainConfig.CLIENT.blacklistedBlocks.get()) {
            Block block;
            if (blockId.isEmpty() || blockId.isBlank() || (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId))) == null) continue;
            BLACKLISTED_BLOCKS.add(block);
        }
        for (String pattern : (List)SoundOfRainConfig.CLIENT.blacklistedBlockNamePatterns.get()) {
            if (pattern.isEmpty() || pattern.isBlank()) continue;
            BLACKLISTED_NAME_PATTERNS.add(pattern);
        }
        if (!(BLACKLISTED_MODS.isEmpty() && BLACKLISTED_TAGS.isEmpty() && BLACKLISTED_BLOCKS.isEmpty() && BLACKLISTED_NAME_PATTERNS.isEmpty())) {
            System.out.println("[SoundOfRain] Loaded blacklists:");
            if (!BLACKLISTED_MODS.isEmpty()) {
                System.out.println("  Blacklisted mods: " + BLACKLISTED_MODS);
            }
            if (!BLACKLISTED_TAGS.isEmpty()) {
                System.out.println("  Blacklisted tags: " + BLACKLISTED_TAGS.size() + " tags");
            }
            if (!BLACKLISTED_BLOCKS.isEmpty()) {
                System.out.println("  Blacklisted blocks: " + BLACKLISTED_BLOCKS);
            }
            if (!BLACKLISTED_NAME_PATTERNS.isEmpty()) {
                System.out.println("  Blacklisted name patterns: " + BLACKLISTED_NAME_PATTERNS);
            }
        }
    }
}

