/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.download;

import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.sound.source.RawAudioSource;
import gg.moonflower.etched.api.sound.source.StreamingAudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.client.AlbumCoverCache;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.HttpUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class SoundSourceManager {
    private static final Set<SoundDownloadSource> SOURCES = new HashSet<SoundDownloadSource>();
    private static final Logger LOGGER = LogManager.getLogger();

    private SoundSourceManager() {
    }

    public static synchronized void registerSource(SoundDownloadSource source) {
        SOURCES.add(source);
    }

    public static CompletableFuture<AudioSource> getAudioSource(String url, @Nullable DownloadProgressListener listener, Proxy proxy, AudioSource.AudioFileType type) throws MalformedURLException {
        Optional<SoundDownloadSource> sourceOptional = SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst();
        CompletableFuture<List<URL>> urlFuture = sourceOptional.isPresent() ? CompletableFuture.supplyAsync(() -> {
            SoundDownloadSource source = (SoundDownloadSource)sourceOptional.get();
            try {
                return source.resolveUrl(url, listener, proxy);
            }
            catch (Exception e) {
                throw new CompletionException("Failed to connect to " + source.getApiName() + " API", e);
            }
        }, (Executor)HttpUtil.f_13936_) : CompletableFuture.completedFuture(Collections.singletonList(new URL(url)));
        return urlFuture.thenApplyAsync(urls -> {
            try {
                if (urls.isEmpty()) {
                    throw new IOException("No audio data was found at the source!");
                }
                if (urls.size() == 1) {
                    return new RawAudioSource((URL)urls.get(0), listener, sourceOptional.map(s -> s.isTemporary(url)).orElse(false), type);
                }
                return new StreamingAudioSource((URL[])urls.toArray(URL[]::new), listener, sourceOptional.map(s -> s.isTemporary(url)).orElse(false), type);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)HttpUtil.f_13936_);
    }

    public static CompletableFuture<TrackData[]> resolveTracks(String url, @Nullable DownloadProgressListener listener, Proxy proxy) throws IOException {
        SoundDownloadSource source = SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst().orElseThrow(() -> new IOException("Unknown source for: " + url));
        return CompletableFuture.supplyAsync(() -> {
            try {
                return (TrackData[])source.resolveTracks(url, listener, proxy).toArray(TrackData[]::new);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)HttpUtil.f_13936_);
    }

    public static CompletableFuture<AlbumCover> resolveAlbumCover(String url, @Nullable DownloadProgressListener listener, Proxy proxy, ResourceManager resourceManager) {
        return CompletableFuture.supplyAsync(() -> SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst().flatMap(source -> {
            try {
                return source.resolveAlbumCover(url, listener, proxy, resourceManager);
            }
            catch (Exception e) {
                LOGGER.error("Failed to connect to " + source.getApiName() + " API", (Throwable)e);
                return Optional.empty();
            }
        }), (Executor)HttpUtil.f_13936_).thenCompose(coverUrl -> coverUrl.map(AlbumCoverCache::requestResource).orElseGet(() -> CompletableFuture.completedFuture(AlbumCover.EMPTY)));
    }

    public static Optional<Component> getBrandText(String url) {
        return SOURCES.stream().filter(source -> source.isValidUrl(url)).findFirst().flatMap(s -> s.getBrandText(url));
    }

    public static boolean isValidUrl(String url) {
        return SOURCES.stream().anyMatch(s -> s.isValidUrl(url));
    }
}

