/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.block;

import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.engine.AmbientEngineLoadException;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;

public abstract class AmbientBlock {
    public static AmbientBlock parse(String data) throws AmbientEngineLoadException {
        if (data.contains("[")) {
            if (!data.endsWith("]")) {
                throw new AmbientEngineLoadException("Cannot parse block entry " + data);
            }
            String[] parts = data.split("\\[");
            if (parts.length > 2) {
                throw new AmbientEngineLoadException("Cannot parse block entry " + data);
            }
            AmbientBlock block = AmbientBlock.parseFirst(parts[0]);
            String[] properties = parts[1].substring(0, parts[1].length() - 1).split(",");
            TupleList found = new TupleList();
            for (int i = 0; i < properties.length; ++i) {
                String[] property = properties[i].split("=");
                if (parts.length != 2) {
                    AmbientSounds.LOGGER.error("Found invalid property condition '{}'. It will be ignored. {}", (Object)properties[i], (Object)data);
                    continue;
                }
                found.add((Object)property[0], (Object)property[1]);
            }
            return new AmbientBlockProperty(block, (TupleList<String, String>)found);
        }
        return AmbientBlock.parseFirst(data);
    }

    private static AmbientBlock parseFirst(String data) {
        if (data.startsWith("#")) {
            return new AmbientBlockTag((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(data.substring(1))));
        }
        return new AmbientBlockBlock(new ResourceLocation(data));
    }

    public abstract boolean is(BlockState var1);

    public static class AmbientBlockProperty
    extends AmbientBlock {
        public final AmbientBlock block;
        public final TupleList<String, String> properties;

        public AmbientBlockProperty(AmbientBlock block, TupleList<String, String> properties) {
            this.block = block;
            this.properties = properties;
        }

        @Override
        public boolean is(BlockState state) {
            if (!this.block.is(state)) {
                return false;
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                Property property = state.m_60734_().m_49965_().m_61081_((String)((Tuple)this.properties.get((int)i)).key);
                if (property == null) {
                    return false;
                }
                Optional value = property.m_6215_((String)((Tuple)this.properties.get((int)i)).value);
                if (value.isPresent() && state.m_61143_(property).equals(value.get())) continue;
                return false;
            }
            return true;
        }
    }

    public static class AmbientBlockTag
    extends AmbientBlock {
        public final TagKey<Block> tag;

        public AmbientBlockTag(TagKey<Block> tag) {
            this.tag = tag;
        }

        @Override
        public boolean is(BlockState state) {
            return state.m_204336_(this.tag);
        }
    }

    public static class AmbientBlockBlock
    extends AmbientBlock {
        public final ResourceLocation block;

        public AmbientBlockBlock(ResourceLocation block) {
            this.block = block;
        }

        @Override
        public boolean is(BlockState state) {
            return state.m_222976_().m_203373_(this.block);
        }
    }
}

