/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.index.fluid_utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import rbasamoyai.createbigcannons.base.LazySupplier;
import rbasamoyai.createbigcannons.index.fluid_utils.CBCFlowingFluid;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class FluidBuilder<T extends CBCFlowingFluid, P>
extends AbstractBuilder<Fluid, T, P, FluidBuilder<T, P>> {
    protected final ResourceLocation stillTexture;
    protected final ResourceLocation flowingTexture;
    public final String sourceName;
    protected final String bucketName;
    protected final NonNullFunction<CBCFlowingFluid.Properties, T> factory;
    @Nullable
    private Boolean defaultSource;
    @Nullable
    private Boolean defaultBlock;
    @Nullable
    private Boolean defaultBucket;
    private NonNullConsumer<CBCFlowingFluid.Properties> properties;
    @Nullable
    private NonNullSupplier<? extends CBCFlowingFluid> source;
    protected List<TagKey<Fluid>> tags = new ArrayList<TagKey<Fluid>>();

    public static <P> FluidBuilder<CBCFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, CBCFlowingFluid.Flowing::new);
    }

    public static <T extends CBCFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<CBCFlowingFluid.Properties, T> factory) {
        return IndexPlatform.createFluidBuilder(owner, parent, name, callback, stillTexture, flowingTexture, factory).defaultLang().defaultSource().defaultBlock().defaultBucket();
    }

    protected FluidBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<CBCFlowingFluid.Properties, T> factory) {
        super(owner, parent, "flowing_" + name, callback, CBCRegistryUtils.getFluidRegistryKey());
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.factory = factory;
        String bucketName = this.bucketName;
        this.properties = p -> p.bucket(() -> (Item)owner.get(bucketName, CBCRegistryUtils.getItemRegistryKey()).get()).block(() -> (LiquidBlock)owner.get(name, CBCRegistryUtils.getBlockRegistryKey()).get());
    }

    public FluidBuilder<T, P> properties(NonNullConsumer<CBCFlowingFluid.Properties> cons) {
        this.properties = this.properties.andThen(cons);
        return this;
    }

    public abstract FluidBuilder<T, P> defaultLang();

    public abstract FluidBuilder<T, P> lang(String var1);

    public FluidBuilder<T, P> defaultSource() {
        if (this.defaultSource != null) {
            throw new IllegalStateException("Cannot set a default source after a custom source has been created");
        }
        this.defaultSource = true;
        return this;
    }

    public FluidBuilder<T, P> source(NonNullFunction<CBCFlowingFluid.Properties, ? extends CBCFlowingFluid> factory) {
        this.defaultSource = false;
        this.source = new LazySupplier<CBCFlowingFluid>(() -> (CBCFlowingFluid)((Object)((Object)factory.apply((Object)this.makeProperties()))));
        return this;
    }

    public FluidBuilder<T, P> defaultBlock() {
        if (this.defaultBlock != null) {
            throw new IllegalStateException("Cannot set a default block after a custom block has been created");
        }
        this.defaultBlock = true;
        return this;
    }

    public abstract BlockBuilder<LiquidBlock, FluidBuilder<T, P>> block();

    public <B extends LiquidBlock> BlockBuilder<B, FluidBuilder<T, P>> block(NonNullBiFunction<NonNullSupplier<? extends T>, BlockBehaviour.Properties, ? extends B> factory) {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        NonNullSupplier supplier = this.asSupplier();
        return this.getOwner().block((Object)this, this.sourceName, p -> (LiquidBlock)factory.apply((Object)supplier, p)).properties(p -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()).blockstate(this::acceptBlockstate);
    }

    protected abstract <B extends Block> void acceptBlockstate(DataGenContext<Block, B> var1, RegistrateBlockstateProvider var2);

    @Beta
    public FluidBuilder<T, P> noBlock() {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        return this;
    }

    public FluidBuilder<T, P> defaultBucket() {
        if (this.defaultBucket != null) {
            throw new IllegalStateException("Cannot set a default bucket after a custom bucket has been created");
        }
        this.defaultBucket = true;
        return this;
    }

    public ItemBuilder<BucketItem, FluidBuilder<T, P>> bucket() {
        return this.bucket(BucketItem::new);
    }

    public <I extends BucketItem> ItemBuilder<I, FluidBuilder<T, P>> bucket(NonNullBiFunction<? extends CBCFlowingFluid, Item.Properties, ? extends I> factory) {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        NonNullSupplier<? extends CBCFlowingFluid> source = this.source;
        if (source == null) {
            throw new IllegalStateException("Cannot create a bucket before creating a source block");
        }
        return this.getOwner().item((Object)this, this.bucketName, p -> (BucketItem)factory.apply((Object)((CBCFlowingFluid)((Object)((Object)this.source.get()))), p)).properties(p -> p.m_41495_(Items.f_42446_).m_41487_(1)).model(this::acceptItemModel);
    }

    protected abstract <I extends BucketItem> void acceptItemModel(DataGenContext<Item, I> var1, RegistrateItemModelProvider var2);

    @Beta
    public FluidBuilder<T, P> noBucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return this;
    }

    public abstract FluidBuilder<T, P> tag(TagKey<Fluid> ... var1);

    @SafeVarargs
    public final FluidBuilder<T, P> removeTag(TagKey<Fluid> ... tags) {
        this.tags.removeAll(Arrays.asList(tags));
        return (FluidBuilder)this.removeTag(ProviderType.FLUID_TAGS, tags);
    }

    protected CBCFlowingFluid getSource() {
        NonNullSupplier<? extends CBCFlowingFluid> source = this.source;
        Preconditions.checkNotNull(source, (Object)("Fluid has no source block: " + this.sourceName));
        return (CBCFlowingFluid)((Object)source.get());
    }

    protected CBCFlowingFluid.Properties makeProperties() {
        NonNullSupplier<? extends CBCFlowingFluid> source = this.source;
        CBCFlowingFluid.Properties ret = new CBCFlowingFluid.Properties((Supplier<? extends Fluid>)source, (Supplier<? extends Fluid>)this.asSupplier(), this.stillTexture, this.flowingTexture);
        this.properties.accept((Object)ret);
        return ret;
    }

    protected T createEntry() {
        return (T)((Object)((CBCFlowingFluid)((Object)this.factory.apply((Object)this.makeProperties()))));
    }

    public RegistryEntry<T> register() {
        NonNullSupplier<? extends CBCFlowingFluid> source;
        if (this.defaultSource == Boolean.TRUE) {
            this.source((NonNullFunction<CBCFlowingFluid.Properties, CBCFlowingFluid>)((NonNullFunction)CBCFlowingFluid.Still::new));
        }
        if (this.defaultBlock == Boolean.TRUE) {
            this.block().register();
        }
        if (this.defaultBucket == Boolean.TRUE) {
            this.bucket().register();
        }
        if ((source = this.source) == null) {
            throw new IllegalStateException("Fluid must have a source version: " + this.getName());
        }
        this.getCallback().accept(this.sourceName, CBCRegistryUtils.getFluidRegistryKey(), (Builder)this, source);
        return super.register();
    }

    protected String makeDescriptionId(T fluid) {
        return Util.m_137492_((String)"fluid", (ResourceLocation)CBCUtils.location(this.getOwner().getModid(), this.sourceName));
    }
}

