/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.integration;

import com.blackgear.platform.common.events.EntityEvents;
import com.blackgear.platform.common.integration.MobInteraction;
import com.blackgear.platform.common.integration.forge.MobIntegrationImpl;
import com.blackgear.platform.core.util.event.CancellableResult;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.levelgen.Heightmap;

public class MobIntegration {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerIntegrations(Consumer<Event> listener) {
        MobIntegrationImpl.registerIntegrations(listener);
    }

    public static interface Event {
        public void registerMobInteraction(MobInteraction var1);

        public void registerAttributes(Supplier<? extends EntityType<? extends LivingEntity>> var1, Supplier<AttributeSupplier.Builder> var2);

        default public <T extends Mob> void registerPlacement(Supplier<EntityType<T>> entity, SpawnPlacements.Type spawnPlacement, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
            SpawnPlacements.m_21754_(entity.get(), (SpawnPlacements.Type)spawnPlacement, (Heightmap.Types)heightmap, spawnPredicate);
        }

        default public void registerGoal(Predicate<Mob> predicate, int priority, Function<Mob, Goal> factory) {
            EntityEvents.ON_SPAWN.register((entity, level) -> {
                Mob mob;
                if (entity instanceof Mob && predicate.test(mob = (Mob)entity)) {
                    mob.f_21345_.m_25352_(priority, (Goal)factory.apply(mob));
                }
                return CancellableResult.PASS;
            });
        }

        default public void registerGoal(EntityType<?> entity, int priority, Function<Mob, Goal> factory) {
            this.registerGoal((Mob mob) -> mob.m_6095_() == entity, priority, factory);
        }

        default public void registerTarget(Predicate<Mob> predicate, int priority, Function<Mob, Goal> factory) {
            EntityEvents.ON_SPAWN.register((entity, level) -> {
                Mob mob;
                if (entity instanceof Mob && predicate.test(mob = (Mob)entity)) {
                    mob.f_21346_.m_25352_(priority, (Goal)factory.apply(mob));
                }
                return CancellableResult.PASS;
            });
        }

        default public void registerTarget(EntityType<? extends Entity> entity, int priority, Function<Mob, Goal> factory) {
            this.registerTarget((Mob mob) -> mob.m_6095_() == entity, priority, factory);
        }
    }
}

