/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;

public class ConfigManager {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).create();
    static final String CONFIG_PATH = "config/particlerain.json";
    public static ConfigData config;
    public static ConfigData defaultConfig;

    public static void load() {
        File file = new File(CONFIG_PATH);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            }
            catch (Exception e) {
                ParticleRain.LOGGER.error("Error loading config: {}", (Object)e.getMessage());
                config = new ConfigData();
                ConfigManager.save();
            }
        } else {
            ParticleRain.LOGGER.info("Creating config file at config/particlerain.json");
            config = new ConfigData();
            ConfigManager.save();
        }
        if (ConfigManager.config.configVersion < ConfigManager.defaultConfig.configVersion) {
            ParticleRain.LOGGER.info("Overwriting old config file");
            config = new ConfigData();
            ConfigManager.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            ParticleRain.LOGGER.error(e.getMessage());
        }
        ConfigManager.updateTransientVariables();
    }

    public static void updateTransientVariables() {
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            opts.biomeList.populateInternalLists();
            opts.blockList.populateInternalLists();
            opts.setPresetParticle();
        }
    }

    public static List<String> getRegistryEntries(Registry<?> registry) {
        ArrayList<String> list = new ArrayList<String>();
        registry.m_6566_().forEach(id -> list.add(id.toString()));
        VersionUtil.getTagIds(registry).forEach(tag -> list.add("#" + String.valueOf(tag.f_203868_())));
        return list;
    }

    static {
        defaultConfig = new ConfigData();
    }

    public static class ColorTypeAdapter
    implements JsonSerializer<Color>,
    JsonDeserializer<Color> {
        public JsonElement serialize(Color color, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(String.join((CharSequence)"", "#", String.format("%02X", color.getRed()), String.format("%02X", color.getGreen()), String.format("%02X", color.getBlue())));
        }

        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Color.decode(json.getAsString());
        }
    }

    public static class UsingCustomTint
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ctx.tintType == ConfigData.TintType.CUSTOM;
        }
    }

    public static class ParticleIsNotDefault
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ConfigManager.defaultConfig.particles.stream().noneMatch(defaultData -> ctx.id.equals(defaultData.id));
        }
    }

    public static class ParticleNotCustom
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ctx.usePresetParticle;
        }
    }

    public static class ParticleIsCustom
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return !ctx.usePresetParticle;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OnlyEditableIf {
        public Class<? extends Function<Object, Boolean>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OnlyVisibleIf {
        public Class<? extends Function<Object, Boolean>> value();
    }

    public static class SupplyBiomes
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return List.of("[!] \u00a7e\u00a7l" + Component.m_237115_((String)"particlerain.suggest").getString());
            }
            return ConfigManager.getRegistryEntries(VersionUtil.getRegistry(Registries.f_256952_));
        }
    }

    public static class SupplyBlocks
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return List.of("[!] \u00a7e\u00a7l" + Component.m_237115_((String)"particlerain.suggest").getString());
            }
            return ConfigManager.getRegistryEntries(BuiltInRegistries.f_256975_);
        }
    }

    public static class SupplyParticleTypes
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry entry : BuiltInRegistries.f_257034_.m_6579_()) {
                if (!(entry.getValue() instanceof SimpleParticleType)) continue;
                list.add(((ResourceKey)entry.getKey()).m_135782_().toString());
            }
            return list;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Dropdown {
        public Class<? extends Supplier<List<String>>> value();
    }

    public static class ClearParticles
    implements Runnable {
        @Override
        public void run() {
            ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).callClearParticles();
            WeatherParticleManager.particleGroup = new ParticleGroup(ConfigManager.config.perf.maxParticleAmount);
        }
    }

    public static class ReloadResources
    implements Runnable {
        @Override
        public void run() {
            Minecraft.m_91087_().m_91391_();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OnChange {
        public Class<? extends Runnable> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RegenScreen {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoGUI {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Group {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BooleanFormat {
        public String t();

        public String f();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Label {
        public String key();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OverrideName {
        public String value();
    }

    public static class ZeroIsAutomatic
    implements Function<Object, Component> {
        @Override
        public Component apply(Object value) {
            return ((Number)value).doubleValue() == 0.0 ? Component.m_237115_((String)"particlerain.auto") : Component.m_237113_((String)value.toString());
        }
    }

    public static class PercentOrOff
    implements Function<Object, Component> {
        @Override
        public Component apply(Object value) {
            return ((Number)value).doubleValue() == 0.0 ? CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED) : Component.m_237113_((String)NumberFormat.getPercentInstance().format(value));
        }
    }

    public static class Percent
    implements Function<Object, Component> {
        @Override
        public Component apply(Object value) {
            return Component.m_237113_((String)NumberFormat.getPercentInstance().format(value));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Format {
        public Class<? extends Function<Object, Component>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Slider {
        public float min() default 0.0f;

        public float max() default 1.0f;

        public float step() default 0.01f;
    }
}

