/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.rftoolsutility.apiimpl.teleportation.TeleportationManager;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.ScreenModuleRegistry;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.tank.TankModule;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.setup.ClientSetup;
import mcjty.rftoolsutility.setup.Config;
import mcjty.rftoolsutility.setup.ModSetup;
import mcjty.rftoolsutility.setup.Registration;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="rftoolsutility")
public class RFToolsUtility {
    public static final String MODID = "rftoolsutility";
    public static final ModSetup setup = new ModSetup();
    public static RFToolsUtility instance;
    private final Modules modules = new Modules();
    public static final ScreenModuleRegistry screenModuleRegistry;

    public RFToolsUtility() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Dist dist = FMLEnvironment.dist;
        instance = this;
        this.setupModules(bus, dist);
        Config.register(bus, this.modules);
        Registration.register(bus);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::processIMC);
        bus.addListener(setup::registerCapabilities);
        bus.addListener(this::onDataGen);
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::renderGameOverlayEvent);
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen);
        datagen.generate();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getTeleportationManager".equals(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(new TeleportationManager());
            } else if ("getScreenModuleRegistry".equalsIgnoreCase(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(screenModuleRegistry);
            }
        });
    }

    private void setupModules(IEventBus bus, Dist dist) {
        this.modules.register((IModule)new CrafterModule());
        this.modules.register((IModule)new LogicBlockModule());
        this.modules.register((IModule)new ScreenModule());
        this.modules.register((IModule)new SpawnerModule());
        this.modules.register((IModule)new TankModule(bus, dist));
        this.modules.register((IModule)new TeleporterModule());
        this.modules.register((IModule)new EnvironmentalModule(bus, dist));
    }

    static {
        screenModuleRegistry = new ScreenModuleRegistry();
    }
}

