/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.modules;

import java.util.ArrayList;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.playerprops.BuffProperties;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class BuffEModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private boolean active = false;
    private int ticks = 180;
    private final PlayerBuff buff;

    public BuffEModule(PlayerBuff buff) {
        this.buff = buff;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void tick(Level world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.m_6907_());
        for (Player player : players) {
            double py = player.m_20186_();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = player.m_20185_();
            double pz = player.m_20189_();
            double sqdist = (px - (double)pos.m_123341_()) * (px - (double)pos.m_123341_()) + (pz - (double)pos.m_123343_()) * (pz - (double)pos.m_123343_());
            if (!(sqdist < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            BuffProperties.addBuffToPlayer(player, this.buff, 180);
        }
    }

    @Override
    public boolean apply(Level world, BlockPos pos, LivingEntity entity, int duration) {
        return false;
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }

    public static BuffEModule create(PlayerBuff buff, final double rfPerTick) {
        return new BuffEModule(buff){

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }
        };
    }
}

