/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MachineInformationScreenModule
implements IScreenModule<IModuleDataString> {
    private int tag;
    protected ResourceKey<Level> dim = Level.f_46428_;
    protected BlockPos coordinate = BlockPosTools.INVALID;

    public IModuleDataString getData(IScreenDataHelper helper, Level worldObj, long millis) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return null;
        }
        BlockEntity te = world.m_7702_(this.coordinate);
        if (te == null) {
            return null;
        }
        return te.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY).map(h -> {
            String info = this.tag < 0 || this.tag >= h.getTagCount() ? "[BAD TAG]" : h.getData(this.tag, millis);
            return helper.createString(info);
        }).orElse(null);
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            this.tag = tagCompound.m_128451_("monitorTag");
            if (tagCompound.m_128441_("monitorx")) {
                this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
                    int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                    int dy = Math.abs(c.m_123342_() - pos.m_123342_());
                    int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.MACHINEINFO_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
    }
}

