/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.client.GuiMatterReceiver;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class MatterReceiverTileEntity
extends TickingTileEntity {
    private final Set<String> allowedPlayers = new HashSet<String>();
    private int id = -1;
    private String name = null;
    @GuiValue
    public static final Value<?, String> VALUE_NAME = Value.create((String)"name", (Type)Type.STRING, MatterReceiverTileEntity::getName, MatterReceiverTileEntity::setName);
    private boolean privateAccess = false;
    @GuiValue(name="private")
    public static final Value<?, Boolean> VALUE_PRIVATE = Value.create((String)"private", (Type)Type.BOOLEAN, MatterReceiverTileEntity::isPrivateAccess, MatterReceiverTileEntity::setPrivateAccess);
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()).intValue(), (long)((Integer)TeleportConfiguration.RECEIVER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Matter Receiver").containerSupplier(DefaultContainerProvider.empty(TeleporterModule.CONTAINER_MATTER_RECEIVER, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusableHandler = new DefaultInfusable((BlockEntity)this);
    private BlockPos cachedPos;
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ADDPLAYER = Command.create((String)"receiver.addPlayer", (te, player, params) -> te.addPlayer((String)params.get(PARAM_PLAYER)));
    @ServerCommand
    public static final Command<?> CMD_DELPLAYER = Command.create((String)"receiver.delPlayer", (te, player, params) -> te.delPlayer((String)params.get(PARAM_PLAYER)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETPLAYERS = ListCommand.create((String)"rftoolsutility.receiver.getPlayers", (te, player, params) -> te.getAllowedPlayers(), (te, player, params, list) -> GuiMatterReceiver.storeAllowedPlayersForClient(list));

    public MatterReceiverTileEntity(BlockPos pos, BlockState state) {
        super(TeleporterModule.TYPE_MATTER_RECEIVER.get(), pos, state);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
            GlobalPos gc = GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)this.m_58899_());
            this.id = destinations.getNewId(gc);
            destinations.save();
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.m_6596_();
    }

    public void setName(String name) {
        this.name = name;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
        TeleportDestination destination = destinations.getDestination(this.m_58899_(), (ResourceKey<Level>)this.f_58857_.m_46472_());
        if (destination != null) {
            destination.setName(name);
            destinations.save();
        }
        this.m_6596_();
    }

    public void storeEnergy(long amount) {
        this.energyStorage.setEnergy(amount);
    }

    protected void tickServer() {
        if (!this.m_58899_().equals((Object)this.cachedPos)) {
            TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
            destinations.removeDestination(this.cachedPos, (ResourceKey<Level>)this.f_58857_.m_46472_());
            this.cachedPos = this.m_58899_();
            GlobalPos gc = GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)this.m_58899_());
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.addDestination(gc);
            destinations.save();
            this.m_6596_();
        }
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.updateDestination();
        this.m_6596_();
    }

    public TeleportDestination updateDestination() {
        GlobalPos gc;
        if (this.f_58857_.m_5776_()) {
            return null;
        }
        TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
        TeleportDestination destination = destinations.getDestination((gc = GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)this.m_58899_())).m_122646_(), (ResourceKey<Level>)gc.m_122640_());
        if (destination != null) {
            destination.setName(this.name);
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
                this.m_6596_();
            } else {
                destinations.assignId(gc, this.id);
            }
            destination.setPrivateAccess(this.privateAccess);
            destination.setAllowedPlayers(this.allowedPlayers);
            destinations.save();
        }
        this.m_6596_();
        return destination;
    }

    public List<String> getAllowedPlayers() {
        return new ArrayList<String>(this.allowedPlayers);
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.updateDestination();
            this.m_6596_();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.updateDestination();
            this.m_6596_();
        }
    }

    public int checkStatus() {
        if (!this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60795_()) {
            return 1;
        }
        if (!this.f_58857_.m_8055_(this.m_58899_().m_6630_(2)).m_60795_()) {
            return 1;
        }
        if (this.getStoredPower() < (Integer)TeleportConfiguration.rfPerTeleportReceiver.get()) {
            return 16;
        }
        return 0;
    }

    private int getStoredPower() {
        return this.energyStorage.getEnergyStored();
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.cachedPos = new BlockPos(tagCompound.m_128451_("cachedX"), tagCompound.m_128451_("cachedY"), tagCompound.m_128451_("cachedZ"));
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(CompoundTag tagCompound) {
        this.energyStorage.setEnergy(tagCompound.m_128454_("Energy"));
        CompoundTag info = tagCompound.m_128469_("Info");
        this.name = info.m_128461_("tpName");
        this.privateAccess = info.m_128471_("private");
        this.allowedPlayers.clear();
        ListTag playerList = info.m_128437_("players", 8);
        for (int i = 0; i < playerList.size(); ++i) {
            this.allowedPlayers.add(playerList.m_128778_(i));
        }
        this.id = info.m_128441_("destinationId") ? info.m_128451_("destinationId") : -1;
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        if (this.cachedPos != null) {
            tagCompound.m_128405_("cachedX", this.cachedPos.m_123341_());
            tagCompound.m_128405_("cachedY", this.cachedPos.m_123342_());
            tagCompound.m_128405_("cachedZ", this.cachedPos.m_123343_());
        }
        this.writeRestorableToNBT(tagCompound);
    }

    public void writeRestorableToNBT(CompoundTag tagCompound) {
        tagCompound.m_128356_("Energy", this.energyStorage.getEnergy());
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            info.m_128359_("tpName", this.name);
        }
        info.m_128379_("private", this.privateAccess);
        ListTag playerTagList = new ListTag();
        for (String player : this.allowedPlayers) {
            playerTagList.add((Object)StringTag.m_129297_((String)player));
        }
        info.m_128365_("players", (Tag)playerTagList);
        info.m_128405_("destinationId", this.id);
    }
}

