/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.teleporter.blocks.SimpleDialerTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SimpleDialerBlock
extends LogicSlabBlock {
    public SimpleDialerBlock() {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"transmitter", SimpleDialerBlock::getTransmitterInfo), TooltipBuilder.parameter((String)"receiver", SimpleDialerBlock::getReceiverInfo), TooltipBuilder.parameter((String)"once", SimpleDialerBlock::hasOnce, stack -> SimpleDialerBlock.hasOnce(stack) ? "Once mode enabled" : "")}).tileEntitySupplier(SimpleDialerTileEntity::new));
    }

    private static boolean hasOnce(ItemStack stack) {
        return (Boolean)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128471_, (String)"once", (Object)false);
    }

    private static String getTransmitterInfo(ItemStack stack) {
        if (NBTTools.hasInfoNBT((ItemStack)stack, (String)"transX")) {
            int transX = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"transX", (Object)0);
            int transY = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"transY", (Object)0);
            int transZ = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"transZ", (Object)0);
            String dim = (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128461_, (String)"transZ", (Object)Level.f_46428_.m_135782_().toString());
            return transX + "," + transY + "," + transZ + " (dim " + dim + ")";
        }
        return "<unset>";
    }

    private static String getReceiverInfo(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, (info, s) -> Integer.toString(info.m_128451_(s)), (String)"receiver", (Object)"<unset>");
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        SimpleDialerTileEntity simpleDialerTileEntity;
        if (!world.f_46443_ && (simpleDialerTileEntity = (SimpleDialerTileEntity)world.m_7702_(pos)) != null) {
            boolean onceMode = !simpleDialerTileEntity.isOnceMode();
            simpleDialerTileEntity.setOnceMode(onceMode);
            if (onceMode) {
                Logging.message((Player)player, (String)"Enabled 'dial once' mode");
            } else {
                Logging.message((Player)player, (String)"Disabled 'dial once' mode");
            }
        }
        return true;
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof SimpleDialerTileEntity) {
            SimpleDialerTileEntity simpleDialer = (SimpleDialerTileEntity)te;
            simpleDialer.update();
        }
    }
}

