/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SimpleDialerTileEntity
extends GenericTileEntity {
    private final LogicSupport support = new LogicSupport();
    private GlobalPos transmitter;
    private Integer receiver;
    private boolean onceMode = false;
    private boolean prevIn = false;

    public SimpleDialerTileEntity(BlockPos pos, BlockState state) {
        super(TeleporterModule.TYPE_SIMPLE_DIALER.get(), pos, state);
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public void update() {
        if (this.transmitter == null) {
            return;
        }
        if (this.powerLevel > 0 == this.prevIn) {
            return;
        }
        this.prevIn = this.powerLevel > 0;
        this.m_6596_();
        if (this.powerLevel > 0) {
            int dial;
            GlobalPos gc;
            TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
            BlockPos coordinate = null;
            ResourceKey dim = Level.f_46428_;
            if (this.receiver != null && (gc = destinations.getCoordinateForId(this.receiver)) != null) {
                coordinate = gc.m_122646_();
                dim = gc.m_122640_();
            }
            if ((dial = TeleportationTools.dial(this.m_58904_(), null, null, this.transmitter.m_122646_(), (ResourceKey<Level>)this.transmitter.m_122640_(), coordinate, (ResourceKey<Level>)dim, this.onceMode)) != 0) {
                // empty if block
            }
        }
    }

    public boolean isOnceMode() {
        return this.onceMode;
    }

    public void setOnceMode(boolean onceMode) {
        this.onceMode = onceMode;
        this.m_6596_();
    }

    public GlobalPos getTransmitter() {
        return this.transmitter;
    }

    public Integer getReceiver() {
        return this.receiver;
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        if (info.m_128441_("transX")) {
            String transDim = info.m_128461_("transDim");
            this.transmitter = GlobalPos.m_122643_((ResourceKey)LevelTools.getId((String)transDim), (BlockPos)new BlockPos(info.m_128451_("transX"), info.m_128451_("transY"), info.m_128451_("transZ")));
        } else {
            this.transmitter = null;
        }
        this.receiver = info.m_128441_("receiver") ? Integer.valueOf(info.m_128451_("receiver")) : null;
        this.onceMode = info.m_128471_("once");
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.transmitter != null) {
            info.m_128405_("transX", this.transmitter.m_122646_().m_123341_());
            info.m_128405_("transY", this.transmitter.m_122646_().m_123342_());
            info.m_128405_("transZ", this.transmitter.m_122646_().m_123343_());
            info.m_128359_("transDim", this.transmitter.m_122640_().m_135782_().toString());
        }
        if (this.receiver != null) {
            info.m_128405_("receiver", this.receiver.intValue());
        }
        info.m_128379_("once", this.onceMode);
    }
}

