/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pump;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class PumpBlock
extends DirectionalKineticBlock
implements SimpleWaterloggedBlock,
ICogWheel,
IBE<PumpBlockEntity> {
    public PumpBlock(BlockBehaviour.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.m_61124_((Property)FACING, (Comparable)((Direction)originalState.m_61143_((Property)FACING)).m_122424_());
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.PUMP.get((Direction)state.m_61143_((Property)FACING));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!PumpBlock.isOpenAt(state, d)) {
            return;
        }
        world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        super.m_7926_(builder);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState toPlace = super.m_5573_(context);
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean isShiftKeyDown = context.m_43723_() != null && context.m_43723_().m_6144_();
        toPlace = ProperWaterloggedBlock.withWater((LevelAccessor)level, toPlace, pos);
        Direction nearestLookingDirection = context.m_7820_();
        Direction targetDirection = isShiftKeyDown ? nearestLookingDirection : nearestLookingDirection.m_122424_();
        Direction bestConnectedDirection = null;
        double bestDistance = Double.MAX_VALUE;
        for (Direction d : Iterate.directions) {
            double distance;
            BlockState adjState;
            BlockPos adjPos = pos.m_121945_(d);
            if (!FluidPipeBlock.canConnectTo((BlockAndTintGetter)level, adjPos, adjState = level.m_8055_(adjPos), d) || (distance = Vec3.m_82528_((Vec3i)d.m_122436_()).m_82554_(Vec3.m_82528_((Vec3i)targetDirection.m_122436_()))) > bestDistance) continue;
            bestDistance = distance;
            bestConnectedDirection = d;
        }
        if (bestConnectedDirection != null && bestConnectedDirection.m_122434_() != targetDirection.m_122434_() && !isShiftKeyDown) {
            return (BlockState)toPlace.m_61124_((Property)FACING, bestConnectedDirection);
        }
        return toPlace;
    }

    public static boolean isPump(BlockState state) {
        return state.m_60734_() instanceof PumpBlock;
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (world.f_46443_) {
            return;
        }
        if (state != oldState) {
            world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
        }
        if (PumpBlock.isPump(state) && PumpBlock.isPump(oldState) && state.m_61143_((Property)FACING) == ((Direction)oldState.m_61143_((Property)FACING)).m_122424_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof PumpBlockEntity)) {
                return;
            }
            PumpBlockEntity pump = (PumpBlockEntity)blockEntity;
            pump.pressureUpdate = true;
        }
    }

    public static boolean isOpenAt(BlockState state, Direction d) {
        return d.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource r) {
        FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = !state.m_60713_(newState.m_60734_());
        if (blockTypeChanged && !world.f_46443_) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public Class<PumpBlockEntity> getBlockEntityClass() {
        return PumpBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends PumpBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.MECHANICAL_PUMP.get();
    }
}

