/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public interface IFilmItem {
    public static final String FRAME_COUNT_TAG = "FrameCount";
    public static final String FRAME_SIZE_TAG = "FrameSize";
    public static final String FRAMES_TAG = "Frames";

    public FilmType getType();

    default public int getDefaultMaxFrameCount(ItemStack filmStack) {
        return 16;
    }

    default public int getMaxFrameCount(ItemStack filmStack) {
        if (filmStack.m_41783_() != null && filmStack.m_41783_().m_128425_(FRAME_COUNT_TAG, 3)) {
            return filmStack.m_41783_().m_128451_(FRAME_COUNT_TAG);
        }
        return this.getDefaultMaxFrameCount(filmStack);
    }

    default public int getDefaultFrameSize() {
        return 320;
    }

    default public int getFrameSize(ItemStack filmStack) {
        if (filmStack.m_41783_() != null && filmStack.m_41783_().m_128425_(FRAME_SIZE_TAG, 3)) {
            return Mth.m_14045_((int)filmStack.m_41784_().m_128451_(FRAME_SIZE_TAG), (int)1, (int)2048);
        }
        return this.getDefaultFrameSize();
    }

    default public boolean hasExposedFrame(ItemStack filmStack, int index) {
        if (index < 0 || filmStack.m_41783_() == null || !filmStack.m_41783_().m_128425_(FRAMES_TAG, 9)) {
            return false;
        }
        ListTag list = filmStack.m_41783_().m_128437_(FRAMES_TAG, 10);
        return index < list.size();
    }

    default public int getExposedFramesCount(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128425_(FRAMES_TAG, 9) ? stack.m_41783_().m_128437_(FRAMES_TAG, 10).size() : 0;
    }

    default public ListTag getExposedFrames(ItemStack filmStack) {
        return filmStack.m_41783_() != null ? filmStack.m_41783_().m_128437_(FRAMES_TAG, 10) : new ListTag();
    }
}

